/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class ShockMine
extends Block {
    protected int timerDamage;
    protected float cooldown;
    protected float tileDamage;
    protected float damage;
    protected int length;
    protected int tendrils;

    public ShockMine(String name) {
        super(name);
        this.timerDamage = this.timers++;
        this.cooldown = 80.0f;
        this.tileDamage = 5.0f;
        this.damage = 13.0f;
        this.length = 10;
        this.tendrils = 6;
        this.update = false;
        this.destructible = true;
        this.solid = false;
        this.targetable = false;
        this.layer = Layer.overlay;
    }

    @Override
    public void drawLayer(Tile tile) {
        super.draw(tile);
        Draw.color(tile.getTeam().color);
        Draw.alpha(0.22f);
        Fill.rect(tile.drawx(), tile.drawy(), 2.0f, 2.0f);
        Draw.color();
    }

    @Override
    public void drawTeam(Tile tile) {
    }

    @Override
    public void draw(Tile tile) {
    }

    @Override
    public void unitOn(Tile tile, Unit unit) {
        if (unit.getTeam() != tile.getTeam() && tile.entity.timer.get(this.timerDamage, this.cooldown)) {
            for (int i = 0; i < this.tendrils; ++i) {
                Lightning.create(tile.getTeam(), Pal.lancerLaser, this.damage, tile.drawx(), tile.drawy(), Mathf.random(360.0f), this.length);
            }
            tile.entity.damage(this.tileDamage);
        }
    }
}

