/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks.defense;

import io.anuke.arc.Core;
import io.anuke.arc.Graphics;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.defense.Wall;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Door
extends Wall {
    protected final Rectangle rect = new Rectangle();
    protected int timerToggle = this.timers++;
    protected Effects.Effect openfx = Fx.dooropen;
    protected Effects.Effect closefx = Fx.doorclose;
    protected TextureRegion openRegion;

    public Door(String name) {
        super(name);
        this.solid = false;
        this.solidifes = true;
        this.consumesTap = true;
    }

    public static void onDoorToggle(Player player, Tile tile, boolean open) {
        DoorEntity entity = (DoorEntity)tile.entity();
        if (entity != null) {
            entity.open = open;
            Door door = (Door)tile.block();
            Vars.pathfinder.updateTile(tile);
            if (!entity.open) {
                Effects.effect(door.openfx, tile.drawx(), tile.drawy());
            } else {
                Effects.effect(door.closefx, tile.drawx(), tile.drawy());
            }
            Sounds.door.at(tile);
        }
    }

    @Override
    public void load() {
        super.load();
        this.openRegion = Core.atlas.find(this.name + "-open");
    }

    @Override
    public void draw(Tile tile) {
        DoorEntity entity = (DoorEntity)tile.entity();
        if (!entity.open) {
            Draw.rect(this.region, tile.drawx(), tile.drawy());
        } else {
            Draw.rect(this.openRegion, tile.drawx(), tile.drawy());
        }
    }

    @Override
    public Graphics.Cursor getCursor(Tile tile) {
        return Graphics.Cursor.SystemCursor.hand;
    }

    @Override
    public boolean isSolidFor(Tile tile) {
        DoorEntity entity = (DoorEntity)tile.entity();
        return !entity.open;
    }

    @Override
    public void tapped(Tile tile, Player player) {
        DoorEntity entity = (DoorEntity)tile.entity();
        if (Units.anyEntities(tile) && entity.open || !tile.entity.timer.get(this.timerToggle, 30.0f)) {
            return;
        }
        Call.onDoorToggle(null, tile, !entity.open);
    }

    @Override
    public TileEntity newEntity() {
        return new DoorEntity();
    }

    public class DoorEntity
    extends TileEntity {
        public boolean open = false;

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeBoolean(this.open);
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.open = stream.readBoolean();
        }
    }
}

