/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.g2d.PixmapPacker;
import io.anuke.arc.graphics.g2d.PixmapRegion;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.OverlayFloor;

public class OreBlock
extends OverlayFloor {
    public OreBlock(Item ore) {
        super("ore-" + ore.name);
        this.localizedName = ore.localizedName();
        this.itemDrop = ore;
        this.variants = 3;
        this.color.set(ore.color);
    }

    public OreBlock(String name) {
        super(name);
        this.variants = 3;
    }

    public void setup(Item ore) {
        this.localizedName = ore.localizedName();
        this.itemDrop = ore;
        this.color.set(ore.color);
    }

    @Override
    public void createIcons(PixmapPacker out, PixmapPacker editor) {
        for (int i = 0; i < this.variants; ++i) {
            Pixmap image = new Pixmap(32, 32);
            PixmapRegion shadow = Core.atlas.getPixmap(this.itemDrop.name + (i + 1));
            int offset = image.getWidth() / 8 - 1;
            Color color = new Color();
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = offset; y < image.getHeight(); ++y) {
                    shadow.getPixel(x, y - offset, color);
                    if (!(color.a > 0.001f)) continue;
                    color.set(0.0f, 0.0f, 0.0f, 0.3f);
                    image.draw(x, y, color);
                }
            }
            image.draw(shadow);
            out.pack(this.name + (i + 1), image);
            editor.pack("editor-" + this.name + (i + 1), image);
            if (i != 0) continue;
            editor.pack("editor-block-" + this.name + "-full", image);
            out.pack("block-" + this.name + "-full", image);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.itemDrop == null) {
            throw new IllegalArgumentException(this.name + " must have an item drop!");
        }
        this.setup(this.itemDrop);
    }

    @Override
    public String getDisplayName(Tile tile) {
        return this.itemDrop.localizedName();
    }
}

