/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;

public class ItemSelection {
    public static void buildItemTable(Table table, Supplier<Item> holder, Consumer<Item> consumer) {
        Array<Item> items = Vars.content.items();
        ButtonGroup group = new ButtonGroup();
        group.setMinCheckCount(0);
        Table cont = new Table();
        cont.defaults().size(38.0f);
        int i = 0;
        for (Item item : items) {
            if (!Vars.data.isUnlocked(item) && Vars.world.isZone()) continue;
            ImageButton button = cont.addImageButton(Tex.whiteui, Styles.clearToggleTransi, 24.0f, () -> Vars.control.input.frag.config.hideConfig()).group(group).get();
            button.changed(() -> consumer.accept(button.isChecked() ? item : null));
            button.getStyle().imageUp = new TextureRegionDrawable(item.icon(Cicon.small));
            button.update(() -> button.setChecked(holder.get() == item));
            if (i++ % 4 != 3) continue;
            cont.row();
        }
        table.add(cont);
    }
}

