/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.Graphics;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.effect.RubbleDecal;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.graphics.Shaders;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.modules.ItemModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BuildBlock
extends Block {
    public static final int maxSize = 9;
    private static final BuildBlock[] buildBlocks = new BuildBlock[9];

    public BuildBlock(int size) {
        super("build" + size);
        this.size = size;
        this.update = true;
        this.health = 20;
        this.layer = Layer.placement;
        this.consumesTap = true;
        this.solidifes = true;
        BuildBlock.buildBlocks[size - 1] = this;
    }

    public static BuildBlock get(int size) {
        if (size > 9) {
            throw new IllegalArgumentException("No. Don't place BuildBlocks of size greater than 9");
        }
        return buildBlocks[size - 1];
    }

    public static void onDeconstructFinish(Tile tile, Block block, int builderID) {
        Team team = tile.getTeam();
        Effects.effect(Fx.breakBlock, tile.drawx(), tile.drawy(), (float)block.size);
        Vars.world.removeBlock(tile);
        Events.fire(new EventType.BlockBuildEndEvent(tile, Vars.playerGroup.getByID(builderID), team, true));
        Sounds.breaks.at(tile, Mathf.random(0.7f, 1.4f));
    }

    public static void onConstructFinish(Tile tile, Block block, int builderID, byte rotation, Team team, boolean skipConfig) {
        if (tile == null) {
            return;
        }
        float healthf = tile.entity == null ? 1.0f : tile.entity.healthf();
        Vars.world.setBlock(tile, block, team, rotation);
        if (tile.entity != null) {
            tile.entity.health = (float)block.health * healthf;
        }
        if (!Vars.headless && builderID == Vars.player.id && !skipConfig) {
            tile.block().playerPlaced(tile);
        }
        Effects.effect(Fx.placeBlock, tile.drawx(), tile.drawy(), (float)block.size);
    }

    public static void constructed(Tile tile, Block block, int builderID, byte rotation, Team team, boolean skipConfig) {
        Call.onConstructFinish(tile, block, builderID, rotation, team, skipConfig);
        tile.block().placed(tile);
        Events.fire(new EventType.BlockBuildEndEvent(tile, Vars.playerGroup.getByID(builderID), team, false));
        Sounds.place.at(tile, Mathf.random(0.7f, 1.4f));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public String getDisplayName(Tile tile) {
        BuildEntity entity = (BuildEntity)tile.entity();
        return Core.bundle.format("block.constructing", entity.cblock == null ? entity.previous.localizedName : entity.cblock.localizedName);
    }

    @Override
    public TextureRegion getDisplayIcon(Tile tile) {
        BuildEntity entity = (BuildEntity)tile.entity();
        return (entity.cblock == null ? entity.previous : entity.cblock).icon(Cicon.full);
    }

    @Override
    public boolean isSolidFor(Tile tile) {
        BuildEntity entity = (BuildEntity)tile.entity();
        return entity == null || entity.cblock != null && entity.cblock.solid || entity.previous == null || entity.previous.solid;
    }

    @Override
    public Graphics.Cursor getCursor(Tile tile) {
        return Graphics.Cursor.SystemCursor.hand;
    }

    @Override
    public void tapped(Tile tile, Player player) {
        BuildEntity entity = (BuildEntity)tile.entity();
        if (entity.cblock != null) {
            player.addBuildRequest(new BuilderTrait.BuildRequest(tile.x, tile.y, tile.rotation(), entity.cblock), false);
        }
    }

    @Override
    public void onDestroyed(Tile tile) {
        Effects.effect(Fx.blockExplosionSmoke, tile);
        if (!tile.floor().solid && !tile.floor().isLiquid) {
            RubbleDecal.create(tile.drawx(), tile.drawy(), this.size);
        }
    }

    @Override
    public void draw(Tile tile) {
        BuildEntity entity = (BuildEntity)tile.entity();
        if (entity.cblock != null && entity.previous == entity.cblock) {
            return;
        }
        if (entity.previous == null) {
            return;
        }
        if (Core.atlas.isFound(entity.previous.icon(Cicon.full))) {
            Draw.rect(entity.previous.icon(Cicon.full), tile.drawx(), tile.drawy(), entity.previous.rotate ? (float)(tile.rotation() * 90) : 0.0f);
        }
    }

    @Override
    public void drawLayer(Tile tile) {
        Block target;
        BuildEntity entity = (BuildEntity)tile.entity();
        Shaders.blockbuild.color = Pal.accent;
        Block block = target = entity.cblock == null ? entity.previous : entity.cblock;
        if (target == null) {
            return;
        }
        TextureRegion[] textureRegionArray = target.getGeneratedIcons();
        int n = textureRegionArray.length;
        for (int i = 0; i < n; ++i) {
            TextureRegion region;
            Shaders.blockbuild.region = region = textureRegionArray[i];
            Shaders.blockbuild.progress = entity.progress;
            Draw.rect(region, tile.drawx(), tile.drawy(), target.rotate ? (float)(tile.rotation() * 90) : 0.0f);
            Draw.flush();
        }
    }

    @Override
    public TileEntity newEntity() {
        return new BuildEntity();
    }

    public class BuildEntity
    extends TileEntity {
        @ArcAnnotate.Nullable
        public Block cblock;
        public float progress = 0.0f;
        public float buildCost;
        public Block previous;
        public int builderID = -1;
        private float[] accumulator;
        private float[] totalAccumulator;

        public boolean construct(Unit builder, @ArcAnnotate.Nullable TileEntity core, float amount, boolean configured) {
            if (this.cblock == null) {
                this.kill();
                return false;
            }
            float maxProgress = core == null ? amount : this.checkRequired(core.items, amount, false);
            for (int i = 0; i < this.cblock.requirements.length; ++i) {
                int reqamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)this.cblock.requirements[i].amount);
                int n = i;
                this.accumulator[n] = this.accumulator[n] + Math.min((float)reqamount * maxProgress, (float)reqamount - this.totalAccumulator[i] + 1.0E-5f);
                this.totalAccumulator[i] = Math.min(this.totalAccumulator[i] + (float)reqamount * maxProgress, (float)reqamount);
            }
            maxProgress = core == null ? maxProgress : this.checkRequired(core.items, maxProgress, true);
            this.progress = Mathf.clamp(this.progress + maxProgress);
            if (builder instanceof Player) {
                this.builderID = builder.getID();
            }
            if (this.progress >= 1.0f || Vars.state.rules.infiniteResources) {
                BuildBlock.constructed(this.tile, this.cblock, this.builderID, this.tile.rotation(), builder.getTeam(), configured);
                return true;
            }
            return false;
        }

        public void deconstruct(Unit builder, @ArcAnnotate.Nullable TileEntity core, float amount) {
            float deconstructMultiplier = 0.5f;
            if (this.cblock != null) {
                ItemStack[] requirements = this.cblock.requirements;
                if (requirements.length != this.accumulator.length || this.totalAccumulator.length != requirements.length) {
                    this.setDeconstruct(this.previous);
                }
                float clampedAmount = Math.min(amount, this.progress);
                for (int i = 0; i < requirements.length; ++i) {
                    int reqamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)requirements[i].amount);
                    int n = i;
                    this.accumulator[n] = this.accumulator[n] + Math.min(clampedAmount * deconstructMultiplier * (float)reqamount, deconstructMultiplier * (float)reqamount - this.totalAccumulator[i]);
                    this.totalAccumulator[i] = Math.min(this.totalAccumulator[i] + (float)reqamount * clampedAmount * deconstructMultiplier, (float)reqamount);
                    int accumulated = (int)this.accumulator[i];
                    if (!(clampedAmount > 0.0f) || accumulated <= 0) continue;
                    if (core != null) {
                        int accepting = core.tile.block().acceptStack(requirements[i].item, accumulated, core.tile, builder);
                        core.tile.block().handleStack(requirements[i].item, accepting, core.tile, builder);
                        int n2 = i;
                        this.accumulator[n2] = this.accumulator[n2] - (float)accepting;
                        continue;
                    }
                    int n3 = i;
                    this.accumulator[n3] = this.accumulator[n3] - (float)accumulated;
                }
            }
            this.progress = Mathf.clamp(this.progress - amount);
            if (this.progress <= 0.0f || Vars.state.rules.infiniteResources) {
                Call.onDeconstructFinish(this.tile, this.cblock == null ? this.previous : this.cblock, this.builderID);
            }
        }

        private float checkRequired(ItemModule inventory, float amount, boolean remove) {
            float maxProgress = amount;
            for (int i = 0; i < this.cblock.requirements.length; ++i) {
                int sclamount = Math.round(Vars.state.rules.buildCostMultiplier * (float)this.cblock.requirements[i].amount);
                int required = (int)this.accumulator[i];
                if (inventory.get(this.cblock.requirements[i].item) == 0 && sclamount != 0) {
                    maxProgress = 0.0f;
                    continue;
                }
                if (required <= 0) continue;
                int maxUse = Math.min(required, inventory.get(this.cblock.requirements[i].item));
                float fraction = (float)maxUse / (float)required;
                maxProgress = Math.min(maxProgress, maxProgress * fraction);
                int n = i;
                this.accumulator[n] = this.accumulator[n] - (float)maxUse;
                if (!remove) continue;
                inventory.remove(this.cblock.requirements[i].item, maxUse);
            }
            return maxProgress;
        }

        public float progress() {
            return this.progress;
        }

        public void setConstruct(Block previous, Block block) {
            this.cblock = block;
            this.previous = previous;
            this.accumulator = new float[block.requirements.length];
            this.totalAccumulator = new float[block.requirements.length];
            this.buildCost = block.buildCost * Vars.state.rules.buildCostMultiplier;
        }

        public void setDeconstruct(Block previous) {
            this.previous = previous;
            this.progress = 1.0f;
            if (previous.buildCost >= 0.01f) {
                this.cblock = previous;
                this.accumulator = new float[previous.requirements.length];
                this.totalAccumulator = new float[previous.requirements.length];
                this.buildCost = previous.buildCost * Vars.state.rules.buildCostMultiplier;
            } else {
                this.buildCost = 20.0f;
            }
        }

        @Override
        public void write(DataOutput stream) throws IOException {
            super.write(stream);
            stream.writeFloat(this.progress);
            stream.writeShort(this.previous == null ? -1 : (int)this.previous.id);
            stream.writeShort(this.cblock == null ? -1 : (int)this.cblock.id);
            if (this.accumulator == null) {
                stream.writeByte(-1);
            } else {
                stream.writeByte(this.accumulator.length);
                for (int i = 0; i < this.accumulator.length; ++i) {
                    stream.writeFloat(this.accumulator[i]);
                    stream.writeFloat(this.totalAccumulator[i]);
                }
            }
        }

        @Override
        public void read(DataInput stream, byte revision) throws IOException {
            super.read(stream, revision);
            this.progress = stream.readFloat();
            short pid = stream.readShort();
            short rid = stream.readShort();
            int acsize = stream.readByte();
            if (acsize != -1) {
                this.accumulator = new float[acsize];
                this.totalAccumulator = new float[acsize];
                for (int i = 0; i < acsize; ++i) {
                    this.accumulator[i] = stream.readFloat();
                    this.totalAccumulator[i] = stream.readFloat();
                }
            }
            if (pid != -1) {
                this.previous = Vars.content.block(pid);
            }
            if (rid != -1) {
                this.cblock = Vars.content.block(rid);
            }
            this.buildCost = this.cblock != null ? this.cblock.buildCost * Vars.state.rules.buildCostMultiplier : 20.0f;
        }
    }
}

