/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world.blocks;

import io.anuke.arc.function.Eachable;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import java.util.Arrays;

public interface Autotiler {
    @ArcAnnotate.Nullable
    default public int[] getTiling(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        if (req.tile() == null) {
            return null;
        }
        Object[] directionals = AutotilerHolder.directionals;
        Arrays.fill(directionals, null);
        list.each(arg_0 -> Autotiler.lambda$getTiling$0(req, (BuilderTrait.BuildRequest[])directionals, arg_0));
        return this.buildBlending(req.tile(), req.rotation, (BuilderTrait.BuildRequest[])directionals, req.worldContext);
    }

    default public int[] buildBlending(Tile tile, int rotation, BuilderTrait.BuildRequest[] directional, boolean world) {
        int[] blendresult = AutotilerHolder.blendresult;
        blendresult[0] = 0;
        blendresult[2] = 1;
        blendresult[1] = 1;
        int num = this.blends(tile, rotation, directional, 2, world) && this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 3, world) ? 0 : (this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 3, world) ? 1 : (this.blends(tile, rotation, directional, 1, world) && this.blends(tile, rotation, directional, 2, world) ? 2 : (this.blends(tile, rotation, directional, 3, world) && this.blends(tile, rotation, directional, 2, world) ? 3 : (this.blends(tile, rotation, directional, 1, world) ? 4 : (this.blends(tile, rotation, directional, 3, world) ? 5 : -1)))));
        this.transformCase(num, blendresult);
        return blendresult;
    }

    default public void transformCase(int num, int[] bits) {
        if (num == 0) {
            bits[0] = 3;
        } else if (num == 1) {
            bits[0] = 4;
        } else if (num == 2) {
            bits[0] = 2;
        } else if (num == 3) {
            bits[0] = 2;
            bits[2] = -1;
        } else if (num == 4) {
            bits[0] = 1;
            bits[2] = -1;
        } else if (num == 5) {
            bits[0] = 1;
        }
    }

    default public boolean blends(Tile tile, int rotation, @ArcAnnotate.Nullable BuilderTrait.BuildRequest[] directional, int direction, boolean checkWorld) {
        int realDir = Mathf.mod(rotation - direction, 4);
        if (directional != null && directional[realDir] != null) {
            BuilderTrait.BuildRequest req = directional[realDir];
            if (this.blends(tile, rotation, req.x, req.y, req.rotation, req.block)) {
                return true;
            }
        }
        return checkWorld && this.blends(tile, rotation, direction);
    }

    default public boolean blends(Tile tile, int rotation, int direction) {
        Tile other = tile.getNearby(Mathf.mod(rotation - direction, 4));
        if (other != null) {
            other = other.link();
        }
        return other != null && this.blends(tile, rotation, other.x, other.y, other.rotation(), other.block());
    }

    default public boolean lookingAt(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return Point2.equals(tile.x + Geometry.d4((int)rotation).x, tile.y + Geometry.d4((int)rotation).y, otherx, othery) || !otherblock.rotate || Point2.equals(otherx + Geometry.d4((int)otherrot).x, othery + Geometry.d4((int)otherrot).y, tile.x, tile.y);
    }

    public boolean blends(Tile var1, int var2, int var3, int var4, int var5, Block var6);

    private static /* synthetic */ void lambda$getTiling$0(BuilderTrait.BuildRequest req, BuilderTrait.BuildRequest[] directionals, BuilderTrait.BuildRequest other) {
        if (other.breaking || other == req) {
            return;
        }
        int i = 0;
        for (Point2 point : Geometry.d4) {
            int x = req.x + point.x;
            int y = req.y + point.y;
            if (x >= other.x - (other.block.size - 1) / 2 && x <= other.x + other.block.size / 2 && y >= other.y - (other.block.size - 1) / 2 && y <= other.y + other.block.size / 2) {
                directionals[i] = other;
            }
            ++i;
        }
    }

    public static class AutotilerHolder {
        static final int[] blendresult = new int[3];
        static final BuilderTrait.BuildRequest[] directionals = new BuilderTrait.BuildRequest[4];
    }
}

