/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.modules.ConsumeModule;
import io.anuke.mindustry.world.modules.ItemModule;
import io.anuke.mindustry.world.modules.LiquidModule;
import io.anuke.mindustry.world.modules.PowerModule;

public class Tile
implements Position,
TargetTrait {
    public byte cost = 1;
    public TileEntity entity;
    public short x;
    public short y;
    protected Block block;
    protected Floor floor;
    protected Floor overlay;
    protected byte rotation;
    protected byte team;

    public Tile(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
        this.floor = this.overlay = (Floor)Blocks.air;
        this.block = this.overlay;
    }

    public Tile(int x, int y, int floor, int overlay, int wall) {
        this.x = (short)x;
        this.y = (short)y;
        this.floor = (Floor)Vars.content.block(floor);
        this.overlay = (Floor)Vars.content.block(overlay);
        this.block = Vars.content.block(wall);
        this.changed();
    }

    public int pos() {
        return Pos.get(this.x, this.y);
    }

    public byte relativeTo(Tile tile) {
        return this.relativeTo(tile.x, tile.y);
    }

    public byte relativeTo(int cx, int cy) {
        if (this.x == cx && this.y == cy - 1) {
            return 1;
        }
        if (this.x == cx && this.y == cy + 1) {
            return 3;
        }
        if (this.x == cx - 1 && this.y == cy) {
            return 0;
        }
        if (this.x == cx + 1 && this.y == cy) {
            return 2;
        }
        return -1;
    }

    public static byte relativeTo(int x, int y, int cx, int cy) {
        if (x == cx && y == cy - 1) {
            return 1;
        }
        if (x == cx && y == cy + 1) {
            return 3;
        }
        if (x == cx - 1 && y == cy) {
            return 0;
        }
        if (x == cx + 1 && y == cy) {
            return 2;
        }
        return -1;
    }

    public byte absoluteRelativeTo(int cx, int cy) {
        if (this.x == cx && this.y <= cy - 1) {
            return 1;
        }
        if (this.x == cx && this.y >= cy + 1) {
            return 3;
        }
        if (this.x <= cx - 1 && this.y == cy) {
            return 0;
        }
        if (this.x >= cx + 1 && this.y == cy) {
            return 2;
        }
        return -1;
    }

    public static byte absoluteRelativeTo(int x, int y, int cx, int cy) {
        if (x == cx && y <= cy - 1) {
            return 1;
        }
        if (x == cx && y >= cy + 1) {
            return 3;
        }
        if (x <= cx - 1 && y == cy) {
            return 0;
        }
        if (x >= cx + 1 && y == cy) {
            return 2;
        }
        return -1;
    }

    public void configure(int value) {
        Call.onTileConfig(Vars.player, this, value);
    }

    public <T extends TileEntity> T entity() {
        return (T)this.entity;
    }

    public float worldx() {
        return this.x * 8;
    }

    public float worldy() {
        return this.y * 8;
    }

    public float drawx() {
        return this.block().offset() + this.worldx();
    }

    public float drawy() {
        return this.block().offset() + this.worldy();
    }

    public boolean isDarkened() {
        return this.block().solid && !this.block().synthetic() && this.block().fillsTile;
    }

    public Floor floor() {
        return this.floor;
    }

    public Block block() {
        return this.block;
    }

    public Floor overlay() {
        return this.overlay;
    }

    public <T extends Block> T cblock() {
        return (T)this.block;
    }

    @Override
    public Team getTeam() {
        return Team.all[this.link().team];
    }

    public void setTeam(Team team) {
        this.team = (byte)team.ordinal();
    }

    public byte getTeamID() {
        return this.team;
    }

    public void setBlock(Block type, Team team, int rotation) {
        this.preChanged();
        this.block = type;
        this.team = (byte)team.ordinal();
        this.rotation = (byte)Mathf.mod(rotation, 4);
        this.changed();
    }

    public void setBlock(Block type, Team team) {
        this.setBlock(type, team, 0);
    }

    public void setBlock(Block type) {
        this.preChanged();
        this.block = type;
        this.rotation = 0;
        this.changed();
    }

    public void setFloor(Floor type) {
        this.floor = type;
        this.overlay = (Floor)Blocks.air;
    }

    public void setFloorUnder(Floor floor) {
        Floor overlay = this.overlay;
        this.setFloor(floor);
        this.setOverlay(overlay);
    }

    public byte rotation() {
        return this.rotation;
    }

    public void rotation(int rotation) {
        this.rotation = (byte)rotation;
    }

    public short overlayID() {
        return this.overlay.id;
    }

    public short blockID() {
        return this.block.id;
    }

    public short floorID() {
        return this.floor.id;
    }

    public void setOverlayID(short ore) {
        this.overlay = (Floor)Vars.content.block(ore);
    }

    public void setOverlay(Block block) {
        this.overlay = (Floor)block;
    }

    public void clearOverlay() {
        this.setOverlayID((short)0);
    }

    public boolean passable() {
        return this.isLinked() || (!this.floor.solid || this.block != Blocks.air && !this.block.solidifes) && (!this.block.solid || this.block.destructible || this.block.update);
    }

    public boolean synthetic() {
        return this.block.update || this.block.destructible;
    }

    public boolean solid() {
        return this.block.solid || this.block.isSolidFor(this) || this.isLinked() && this.link().solid();
    }

    public boolean breakable() {
        return !this.isLinked() ? this.block.destructible || this.block.breakable || this.block.update : this.link().breakable();
    }

    public Tile link() {
        return this.block.linked(this);
    }

    public boolean isEnemyCheat() {
        return this.getTeam() == Vars.waveTeam && Vars.state.rules.enemyCheat;
    }

    public boolean isLinked() {
        return this.block instanceof BlockPart;
    }

    public void getLinkedTiles(Consumer<Tile> cons) {
        if (this.block.isMultiblock()) {
            int size = this.block.size;
            int offsetx = -(size - 1) / 2;
            int offsety = -(size - 1) / 2;
            for (int dx = 0; dx < size; ++dx) {
                for (int dy = 0; dy < size; ++dy) {
                    Tile other = Vars.world.tile(this.x + dx + offsetx, this.y + dy + offsety);
                    if (other == null) continue;
                    cons.accept(other);
                }
            }
        } else {
            cons.accept(this);
        }
    }

    public Array<Tile> getLinkedTiles(Array<Tile> tmpArray) {
        tmpArray.clear();
        this.getLinkedTiles(tmpArray::add);
        return tmpArray;
    }

    public Array<Tile> getLinkedTilesAs(Block block, Array<Tile> tmpArray) {
        tmpArray.clear();
        if (block.isMultiblock()) {
            int offsetx = -(block.size - 1) / 2;
            int offsety = -(block.size - 1) / 2;
            for (int dx = 0; dx < block.size; ++dx) {
                for (int dy = 0; dy < block.size; ++dy) {
                    Tile other = Vars.world.tile(this.x + dx + offsetx, this.y + dy + offsety);
                    if (other == null) continue;
                    tmpArray.add(other);
                }
            }
        } else {
            tmpArray.add(this);
        }
        return tmpArray;
    }

    public Rectangle getHitbox(Rectangle rect) {
        return rect.setSize(this.block().size * 8).setCenter(this.drawx(), this.drawy());
    }

    public Tile getNearby(Point2 relative) {
        return Vars.world.tile(this.x + relative.x, this.y + relative.y);
    }

    public Tile getNearby(int dx, int dy) {
        return Vars.world.tile(this.x + dx, this.y + dy);
    }

    public Tile getNearby(int rotation) {
        if (rotation == 0) {
            return Vars.world.tile(this.x + 1, this.y);
        }
        if (rotation == 1) {
            return Vars.world.tile(this.x, this.y + 1);
        }
        if (rotation == 2) {
            return Vars.world.tile(this.x - 1, this.y);
        }
        if (rotation == 3) {
            return Vars.world.tile(this.x, this.y - 1);
        }
        return null;
    }

    public boolean interactable(Team team) {
        return this.getTeam() == Team.derelict || team == this.getTeam();
    }

    public Item drop() {
        return this.overlay == Blocks.air || this.overlay.itemDrop == null ? this.floor.itemDrop : this.overlay.itemDrop;
    }

    public void updateOcclusion() {
        this.cost = 1;
        boolean occluded = false;
        for (int i = 0; i < 8; ++i) {
            Point2 point = Geometry.d8[i];
            Tile tile = Vars.world.tile(this.x + point.x, this.y + point.y);
            if (tile != null && tile.floor.isLiquid) {
                this.cost = (byte)(this.cost + 4);
            }
            if (tile == null || !tile.solid()) continue;
            occluded = true;
            break;
        }
        if (occluded) {
            this.cost = (byte)(this.cost + 2);
        }
        if (this.link().synthetic() && this.link().solid()) {
            this.cost = (byte)((float)this.cost + Mathf.clamp((float)this.link().block.health / 10.0f, 0.0f, 20.0f));
        }
        if (this.floor.isLiquid) {
            this.cost = (byte)(this.cost + 10);
        }
        if (this.floor.drownTime > 0.0f) {
            this.cost = (byte)(this.cost + 70);
        }
        if (this.cost < 0) {
            this.cost = (byte)127;
        }
    }

    protected void preChanged() {
        this.block().removed(this);
        if (this.entity != null) {
            this.entity.removeFromProximity();
        }
        this.team = 0;
    }

    protected void changed() {
        Block block;
        if (this.entity != null) {
            this.entity.remove();
            this.entity = null;
        }
        if ((block = this.block()).hasEntity()) {
            this.entity = block.newEntity().init(this, block.update);
            this.entity.cons = new ConsumeModule(this.entity);
            if (block.hasItems) {
                this.entity.items = new ItemModule();
            }
            if (block.hasLiquids) {
                this.entity.liquids = new LiquidModule();
            }
            if (block.hasPower) {
                this.entity.power = new PowerModule();
                this.entity.power.graph.add(this);
            }
            if (!Vars.world.isGenerating()) {
                this.entity.updateProximity();
            }
        } else if (!(block instanceof BlockPart) && !Vars.world.isGenerating()) {
            for (Point2 p : Geometry.d4) {
                Tile tile = Vars.world.ltile(this.x + p.x, this.y + p.y);
                if (tile == null) continue;
                tile.block().onProximityUpdate(tile);
            }
        }
        this.updateOcclusion();
        Vars.world.notifyChanged(this);
    }

    @Override
    public boolean isDead() {
        return this.entity == null;
    }

    @Override
    public Vector2 velocity() {
        return Vector2.ZERO;
    }

    @Override
    public float getX() {
        return this.drawx();
    }

    @Override
    public void setX(float x) {
        throw new IllegalArgumentException("Tile position cannot change.");
    }

    @Override
    public float getY() {
        return this.drawy();
    }

    @Override
    public void setY(float y) {
        throw new IllegalArgumentException("Tile position cannot change.");
    }

    public String toString() {
        return this.floor.name + ":" + this.block.name + ":" + this.overlay + "[" + this.x + "," + this.y + "] entity=" + (this.entity == null ? "null" : this.entity.getClass()) + ":" + (Object)((Object)this.getTeam());
    }
}

