/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.StaticWall;

public class StaticTree
extends StaticWall {
    public StaticTree(String name) {
        super(name);
    }

    @Override
    public void draw(Tile tile) {
        TextureRegion r = Tmp.tr1;
        r.set(this.region);
        int crop = (this.region.getWidth() - 32) / 2;
        float ox = 0.0f;
        float oy = 0.0f;
        for (int i = 0; i < 4; ++i) {
            if (tile.getNearby(i) == null || !(tile.getNearby(i).block() instanceof StaticWall)) continue;
            if (i == 0) {
                r.setWidth(r.getWidth() - crop);
                ox -= (float)crop / 2.0f;
                continue;
            }
            if (i == 1) {
                r.setY(r.getY() + crop);
                oy -= (float)crop / 2.0f;
                continue;
            }
            if (i == 2) {
                r.setX(r.getX() + crop);
                ox += (float)crop / 2.0f;
                continue;
            }
            r.setHeight(r.getHeight() - crop);
            oy += (float)crop / 2.0f;
        }
        Draw.rect(r, tile.drawx() + ox * Draw.scl, tile.drawy() + oy * Draw.scl);
    }
}

