/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.BufferItem;
import io.anuke.mindustry.type.Item;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DirectionalItemBuffer {
    public final long[][] buffers;
    public final int[] indexes;
    private final float speed;

    public DirectionalItemBuffer(int capacity, float speed) {
        this.buffers = new long[4][capacity];
        this.indexes = new int[5];
        this.speed = speed;
    }

    public boolean accepts(int buffer) {
        return this.indexes[buffer] < this.buffers[buffer].length;
    }

    public void accept(int buffer, Item item) {
        if (!this.accepts(buffer)) {
            return;
        }
        int n = buffer;
        int n2 = this.indexes[n];
        this.indexes[n] = n2 + 1;
        this.buffers[buffer][n2] = BufferItem.get((byte)item.id, Time.time());
    }

    public Item poll(int buffer) {
        if (this.indexes[buffer] > 0) {
            long l = this.buffers[buffer][0];
            float time = BufferItem.time(l);
            if (Time.time() >= time + this.speed || Time.time() < time) {
                return Vars.content.item(BufferItem.item(l));
            }
        }
        return null;
    }

    public void remove(int buffer) {
        System.arraycopy(this.buffers[buffer], 1, this.buffers[buffer], 0, this.indexes[buffer] - 1);
        int n = buffer;
        this.indexes[n] = this.indexes[n] - 1;
    }

    public void write(DataOutput stream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            stream.writeByte(this.indexes[i]);
            stream.writeByte(this.buffers[i].length);
            for (long l : this.buffers[i]) {
                stream.writeLong(l);
            }
        }
    }

    public void read(DataInput stream) throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.indexes[i] = stream.readByte();
            int length = stream.readByte();
            for (int j = 0; j < length; ++j) {
                long value = stream.readLong();
                if (j >= this.buffers[i].length) continue;
                this.buffers[i][j] = value;
            }
        }
    }

    class BufferItemStruct {
        byte item;
        float time;

        BufferItemStruct() {
        }
    }
}

