/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.world;

import io.anuke.arc.Core;
import io.anuke.arc.Graphics;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.function.Eachable;
import io.anuke.arc.function.Function;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.PixmapPacker;
import io.anuke.arc.graphics.g2d.PixmapRegion;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.TargetPriority;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.effect.RubbleDecal;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.graphics.Layer;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Category;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Bar;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.ContentDisplay;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.world.BlockStorage;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OverlayFloor;
import io.anuke.mindustry.world.blocks.power.PowerNode;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeLiquid;
import io.anuke.mindustry.world.consumers.ConsumePower;
import io.anuke.mindustry.world.consumers.ConsumeType;
import io.anuke.mindustry.world.meta.Attribute;
import io.anuke.mindustry.world.meta.BlockFlag;
import io.anuke.mindustry.world.meta.BlockGroup;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BuildVisibility;
import io.anuke.mindustry.world.meta.StatUnit;
import io.anuke.mindustry.world.meta.values.ItemListValue;
import java.util.Arrays;

public class Block
extends BlockStorage {
    public static final int crackRegions = 8;
    public static final int maxCrackSize = 5;
    public boolean update;
    public boolean destructible;
    public boolean unloadable = true;
    public boolean solid;
    public boolean solidifes;
    public boolean rotate;
    public boolean breakable;
    public boolean placeableOn = true;
    public int health = -1;
    public float baseExplosiveness = 0.0f;
    public boolean floating = false;
    public int size = 1;
    public boolean expanded = false;
    public int timers = 0;
    public CacheLayer cacheLayer = CacheLayer.normal;
    public boolean fillsTile = true;
    public Layer layer = null;
    public Layer layer2 = null;
    public boolean alwaysReplace = false;
    public BlockGroup group = BlockGroup.none;
    public EnumSet<BlockFlag> flags = EnumSet.of((Enum[])new BlockFlag[0]);
    public TargetPriority priority = TargetPriority.base;
    public boolean configurable;
    public boolean consumesTap;
    public boolean posConfig;
    public Color color = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public boolean targetable = true;
    public boolean canOverdrive = true;
    public Color outlineColor = Color.valueOf("404049");
    public boolean outlineIcon = false;
    public boolean hasShadow = true;
    public Sound breakSound = Sounds.boom;
    public Sound activeSound = Sounds.none;
    public float activeSoundVolume = 0.5f;
    public Sound idleSound = Sounds.none;
    public float idleSoundVolume = 0.5f;
    public ItemStack[] requirements = new ItemStack[0];
    public Category category = Category.distribution;
    public float buildCost;
    public BuildVisibility buildVisibility = BuildVisibility.hidden;
    public float buildCostMultiplier = 1.0f;
    public boolean instantTransfer = false;
    public boolean alwaysUnlocked = false;
    protected TextureRegion[] cacheRegions = new TextureRegion[0];
    protected Array<String> cacheRegionStrings = new Array();
    protected Array<Tile> tempTiles = new Array();
    protected TextureRegion[] generatedIcons;
    protected TextureRegion[] variantRegions;
    protected TextureRegion[] editorVariantRegions;
    protected TextureRegion region;
    protected TextureRegion editorIcon;
    protected static TextureRegion[][] cracks;
    protected final int timerDump = this.timers++;
    protected final int dumpTime = 5;

    public Block(String name) {
        super(name);
        this.description = Core.bundle.getOrNull("block." + name + ".description");
        this.solid = false;
    }

    public boolean canBreak(Tile tile) {
        return true;
    }

    public boolean isBuildable() {
        return this.buildVisibility != BuildVisibility.hidden && this.buildVisibility != BuildVisibility.debugOnly;
    }

    public boolean isStatic() {
        return this.cacheLayer == CacheLayer.walls;
    }

    public void onProximityRemoved(Tile tile) {
        if (tile.entity.power != null) {
            tile.block().powerGraphRemoved(tile);
        }
    }

    public void onProximityAdded(Tile tile) {
        if (tile.block().hasPower) {
            tile.block().updatePowerGraph(tile);
        }
    }

    protected void updatePowerGraph(Tile tile) {
        Object entity = tile.entity();
        for (Tile other : this.getPowerConnections(tile, this.tempTiles)) {
            if (other.entity.power == null) continue;
            other.entity.power.graph.add(((TileEntity)entity).power.graph);
        }
    }

    protected void powerGraphRemoved(Tile tile) {
        if (tile.entity == null || tile.entity.power == null) {
            return;
        }
        tile.entity.power.graph.remove(tile);
        for (int i = 0; i < tile.entity.power.links.size; ++i) {
            Tile other = Vars.world.tile(tile.entity.power.links.get(i));
            if (other == null || other.entity == null || other.entity.power == null) continue;
            other.entity.power.links.removeValue(tile.pos());
        }
    }

    public Array<Tile> getPowerConnections(Tile tile, Array<Tile> out) {
        out.clear();
        if (tile == null || tile.entity == null || tile.entity.power == null) {
            return out;
        }
        for (Tile other : tile.entity.proximity()) {
            if (other == null || other.entity == null || other.entity.power == null || this.consumesPower && other.block().consumesPower && !this.outputsPower && !other.block().outputsPower || tile.entity.power.links.contains(other.pos())) continue;
            out.add(other);
        }
        for (int i = 0; i < tile.entity.power.links.size; ++i) {
            Tile link = Vars.world.tile(tile.entity.power.links.get(i));
            if (link == null || link.entity == null || link.entity.power == null) continue;
            out.add(link);
        }
        return out;
    }

    protected float getProgressIncrease(TileEntity entity, float baseTime) {
        float progressIncrease = 1.0f / baseTime * entity.delta();
        if (this.hasPower) {
            progressIncrease *= entity.power.satisfaction;
        }
        return progressIncrease;
    }

    public boolean shouldActiveSound(Tile tile) {
        return false;
    }

    public boolean shouldIdleSound(Tile tile) {
        return this.canProduce(tile);
    }

    public void drawLayer(Tile tile) {
    }

    public void drawLayer2(Tile tile) {
    }

    public void drawCracks(Tile tile) {
        if (!tile.entity.damaged()) {
            return;
        }
        int id = tile.pos();
        TextureRegion region = cracks[this.size - 1][Mathf.clamp((int)((1.0f - tile.entity.healthf()) * 8.0f), 0, 7)];
        Draw.colorl(0.2f, 0.1f + (1.0f - tile.entity.healthf()) * 0.6f);
        Draw.rect(region, tile.drawx(), tile.drawy(), (float)(id % 4 * 90));
        Draw.color();
    }

    public void drawSelect(Tile tile) {
    }

    public void drawPlace(int x, int y, int rotation, boolean valid) {
    }

    public float drawPlaceText(String text, int x, int y, boolean valid) {
        if (Vars.renderer.pixelator.enabled()) {
            return 0.0f;
        }
        Color color = valid ? Pal.accent : Pal.remove;
        BitmapFont font = Fonts.outline;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        layout.setText(font, text);
        float width = layout.width;
        font.setColor(color);
        float dx = (float)(x * 8) + this.offset();
        float dy = (float)(y * 8) + this.offset() + (float)(this.size * 8) / 2.0f + 3.0f;
        font.draw(text, dx, dy + layout.height + 1.0f, 1);
        Lines.stroke(2.0f, Color.darkGray);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy -= 1.0f, dx + layout.width / 2.0f + 1.5f, dy);
        Lines.stroke(1.0f, color);
        Lines.line(dx - layout.width / 2.0f - 2.0f, dy, dx + layout.width / 2.0f + 1.5f, dy);
        font.setUseIntegerPositions(ints);
        font.setColor(Color.white);
        font.getData().setScale(1.0f);
        Draw.reset();
        Pools.free(layout);
        return width;
    }

    public void draw(Tile tile) {
        Draw.rect(this.region, tile.drawx(), tile.drawy(), this.rotate ? (float)(tile.rotation() * 90) : 0.0f);
    }

    public void drawTeam(Tile tile) {
        Draw.color(tile.getTeam().color);
        Draw.rect("block-border", tile.drawx() - (float)(this.size * 8) / 2.0f + 4.0f, tile.drawy() - (float)(this.size * 8) / 2.0f + 4.0f);
        Draw.color();
    }

    public void playerPlaced(Tile tile) {
    }

    public void placed(Tile tile) {
        if (Vars.net.client()) {
            return;
        }
        if (this.consumesPower && !this.outputsPower || !this.consumesPower && this.outputsPower) {
            int range = 10;
            this.tempTiles.clear();
            Geometry.circle(tile.x, tile.y, range, (x, y) -> {
                Tile other = Vars.world.ltile(x, y);
                if (!(other == null || !(other.block instanceof PowerNode) || !((PowerNode)other.block).linkValid(other, tile) || other.entity.proximity().contains(tile) || this.outputsPower && tile.entity.proximity().contains((Tile)((Object)((Predicate<Tile>)p -> p.entity != null && p.entity.power != null && p.entity.power.graph == other.entity.power.graph))))) {
                    this.tempTiles.add(other);
                }
            });
            this.tempTiles.sort(Structs.comparingFloat(t -> t.dst2(tile)));
            if (!this.tempTiles.isEmpty()) {
                Tile toLink = this.tempTiles.first();
                if (!toLink.entity.power.links.contains(tile.pos())) {
                    toLink.configure(tile.pos());
                }
            }
        }
    }

    public void removed(Tile tile) {
    }

    public void unitOn(Tile tile, Unit unit) {
    }

    public void unitRemoved(Tile tile, Unit unit) {
    }

    public boolean canPlaceOn(Tile tile) {
        return true;
    }

    public void useContent(Tile tile, UnlockableContent content) {
        if (!Vars.headless && tile.getTeam() == Vars.player.getTeam() && Vars.world.isZone()) {
            Vars.logic.handleContent(content);
        }
    }

    public float sumAttribute(Attribute attr, int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile == null) {
            return 0.0f;
        }
        float sum = 0.0f;
        for (Tile other : tile.getLinkedTilesAs(this, this.tempTiles)) {
            sum += other.floor().attributes.get(attr);
        }
        return sum;
    }

    @Override
    public String localizedName() {
        return this.localizedName;
    }

    @Override
    public void displayInfo(Table table) {
        ContentDisplay.displayBlock(table, this);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.block;
    }

    @Override
    public void init() {
        if (this.health == -1) {
            this.health = this.size * this.size * 40;
        }
        this.buildCost = 0.0f;
        for (ItemStack stack : this.requirements) {
            this.buildCost += (float)stack.amount * stack.item.cost;
        }
        this.buildCost *= this.buildCostMultiplier;
        if (this.consumes.has(ConsumeType.power)) {
            this.hasPower = true;
        }
        if (this.consumes.has(ConsumeType.item)) {
            this.hasItems = true;
        }
        if (this.consumes.has(ConsumeType.liquid)) {
            this.hasLiquids = true;
        }
        this.setStats();
        this.setBars();
        this.consumes.init();
        if (!this.outputsPower && this.consumes.hasPower() && this.consumes.getPower().buffered) {
            throw new IllegalArgumentException("Consumer using buffered power: " + this.name);
        }
    }

    @Override
    public void load() {
        this.region = Core.atlas.find(this.name);
        this.cacheRegions = new TextureRegion[this.cacheRegionStrings.size];
        for (int i = 0; i < this.cacheRegions.length; ++i) {
            this.cacheRegions[i] = Core.atlas.find(this.cacheRegionStrings.get(i));
        }
        if (cracks == null || cracks[0][0].getTexture() != null && cracks[0][0].getTexture().isDisposed()) {
            cracks = new TextureRegion[5][8];
            for (int size = 1; size <= 5; ++size) {
                for (int i = 0; i < 8; ++i) {
                    Block.cracks[size - 1][i] = Core.atlas.find("cracks-" + size + "-" + i);
                }
            }
        }
    }

    protected int reg(String suffix) {
        this.cacheRegionStrings.add(this.name + suffix);
        return this.cacheRegionStrings.size - 1;
    }

    protected TextureRegion reg(int id) {
        return this.cacheRegions[id];
    }

    public void tapped(Tile tile, Player player) {
    }

    public void configured(Tile tile, @ArcAnnotate.Nullable Player player, int value) {
    }

    public Graphics.Cursor getCursor(Tile tile) {
        return this.configurable ? Graphics.Cursor.SystemCursor.hand : Graphics.Cursor.SystemCursor.arrow;
    }

    public void buildTable(Tile tile, Table table) {
    }

    public void updateTableAlign(Tile tile, Table table) {
        Vector2 pos = Core.input.mouseScreen(tile.drawx(), tile.drawy() - (float)(tile.block().size * 8) / 2.0f - 1.0f);
        table.setPosition(pos.x, pos.y, 2);
    }

    public boolean onConfigureTileTapped(Tile tile, Tile other) {
        return tile != other;
    }

    public boolean shouldShowConfigure(Tile tile, Player player) {
        return true;
    }

    public boolean shouldHideConfigure(Tile tile, Player player) {
        return false;
    }

    public boolean synthetic() {
        return this.update || this.destructible;
    }

    public void drawConfigure(Tile tile) {
        Draw.color(Pal.accent);
        Lines.stroke(1.0f);
        Lines.square(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f + 1.0f);
        Draw.reset();
    }

    public void setStats() {
        this.stats.add(BlockStat.size, "{0}x{0}", this.size);
        this.stats.add(BlockStat.health, this.health, StatUnit.none);
        if (this.isBuildable()) {
            this.stats.add(BlockStat.buildTime, this.buildCost / 60.0f, StatUnit.seconds);
            this.stats.add(BlockStat.buildCost, new ItemListValue(false, this.requirements));
        }
        this.consumes.display(this.stats);
        if (this.hasLiquids) {
            this.stats.add(BlockStat.liquidCapacity, this.liquidCapacity, StatUnit.liquidUnits);
        }
        if (this.hasItems) {
            this.stats.add(BlockStat.itemCapacity, this.itemCapacity, StatUnit.items);
        }
    }

    public void setBars() {
        this.bars.add("health", entity -> new Bar("blocks.health", Pal.health, entity::healthf).blink(Color.white));
        if (this.hasLiquids) {
            Function<TileEntity, Liquid> current;
            if (this.consumes.has(ConsumeType.liquid) && this.consumes.get(ConsumeType.liquid) instanceof ConsumeLiquid) {
                Liquid liquid = ((ConsumeLiquid)this.consumes.get((ConsumeType)ConsumeType.liquid)).liquid;
                current = entity -> liquid;
            } else {
                current = entity -> entity.liquids.current();
            }
            this.bars.add("liquid", entity -> new Bar(() -> entity.liquids.get((Liquid)current.get((TileEntity)entity)) <= 0.001f ? Core.bundle.get("bar.liquid") : ((Liquid)current.get((TileEntity)entity)).localizedName(), () -> ((Liquid)current.get(entity)).color, () -> entity.liquids.get((Liquid)current.get((TileEntity)entity)) / this.liquidCapacity));
        }
        if (this.hasPower && this.consumes.hasPower()) {
            ConsumePower cons = this.consumes.getPower();
            boolean buffered = cons.buffered;
            float capacity = cons.capacity;
            this.bars.add("power", entity -> new Bar(() -> buffered ? Core.bundle.format("bar.poweramount", Float.isNaN(entity.power.satisfaction * capacity) ? "<ERROR>" : Integer.valueOf((int)(entity.power.satisfaction * capacity))) : Core.bundle.get("bar.power"), () -> Pal.powerBar, () -> Mathf.isZero(cons.requestedPower((TileEntity)entity)) && entity.power.graph.getPowerProduced() + entity.power.graph.getBatteryStored() > 0.0f ? 1.0f : entity.power.satisfaction));
        }
        if (this.hasItems && this.configurable) {
            this.bars.add("items", entity -> new Bar(() -> Core.bundle.format("bar.items", entity.items.total()), () -> Pal.items, () -> (float)entity.items.total() / (float)this.itemCapacity));
        }
    }

    public Tile linked(Tile tile) {
        return tile;
    }

    public boolean isSolidFor(Tile tile) {
        return false;
    }

    public boolean canReplace(Block other) {
        return (other != this || this.rotate) && this.group != BlockGroup.none && other.group == this.group;
    }

    public float handleDamage(Tile tile, float amount) {
        return amount;
    }

    public void handleBulletHit(TileEntity entity, Bullet bullet) {
        entity.damage(bullet.damage());
    }

    public void update(Tile tile) {
    }

    public boolean isAccessible() {
        return this.hasItems && this.itemCapacity > 0;
    }

    public void onDestroyed(Tile tile) {
        float x = tile.worldx();
        float y = tile.worldy();
        float explosiveness = this.baseExplosiveness;
        float flammability = 0.0f;
        float power = 0.0f;
        if (this.hasItems) {
            for (Item item : Vars.content.items()) {
                int amount2 = tile.entity.items.get(item);
                explosiveness += item.explosiveness * (float)amount2;
                flammability += item.flammability * (float)amount2;
            }
        }
        if (this.hasLiquids) {
            flammability += tile.entity.liquids.sum((liquid, amount) -> liquid.explosiveness * amount / 2.0f);
            explosiveness += tile.entity.liquids.sum((liquid, amount) -> liquid.flammability * amount / 2.0f);
        }
        if (this.consumes.hasPower() && this.consumes.getPower().buffered) {
            power += tile.entity.power.satisfaction * this.consumes.getPower().capacity;
        }
        if (this.hasLiquids) {
            tile.entity.liquids.forEach((liquid, amount) -> {
                float splash = Mathf.clamp(amount / 4.0f, 0.0f, 10.0f);
                int i = 0;
                while ((float)i < Mathf.clamp(amount / 5.0f, 0.0f, 30.0f)) {
                    Time.run((float)i / 2.0f, () -> {
                        Tile other = Vars.world.tile(tile.x + Mathf.range(this.size / 2), tile.y + Mathf.range(this.size / 2));
                        if (other != null) {
                            Puddle.deposit(other, liquid, splash);
                        }
                    });
                    ++i;
                }
            });
        }
        Damage.dynamicExplosion(x, y, flammability, explosiveness * 3.5f, power, (float)(8 * this.size) / 2.0f, Pal.darkFlame);
        if (!tile.floor().solid && !tile.floor().isLiquid) {
            RubbleDecal.create(tile.drawx(), tile.drawy(), this.size);
        }
    }

    public float getFlammability(Tile tile) {
        if (!this.hasItems || tile.entity == null) {
            if (tile.floor().isLiquid && !this.solid) {
                return tile.floor().liquidDrop.flammability;
            }
            return 0.0f;
        }
        float result = tile.entity.items.sum((item, amount) -> item.flammability * (float)amount);
        if (this.hasLiquids) {
            result += tile.entity.liquids.sum((liquid, amount) -> liquid.flammability * amount / 3.0f);
        }
        return result;
    }

    public String getDisplayName(Tile tile) {
        return this.localizedName;
    }

    public TextureRegion getDisplayIcon(Tile tile) {
        return this.icon(Cicon.medium);
    }

    public void display(Tile tile, Table table) {
        TileEntity entity = tile.entity;
        if (entity != null) {
            table.table(bars -> {
                bars.defaults().growX().height(18.0f).pad(4.0f);
                this.displayBars(tile, (Table)bars);
            }).growX();
            table.row();
            table.table(ctable -> this.displayConsumption(tile, (Table)ctable)).growX();
            table.marginBottom(-5.0f);
        }
    }

    public void displayConsumption(Tile tile, Table table) {
        table.left();
        for (Consume cons : this.consumes.all()) {
            if (cons.isOptional() && cons.isBoost()) continue;
            cons.build(tile, table);
        }
    }

    public void displayBars(Tile tile, Table table) {
        for (Function<TileEntity, Bar> bar : this.bars.list()) {
            table.add((Element)bar.get(tile.entity)).growX();
            table.row();
        }
    }

    public void drawRequest(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list, boolean valid) {
        Draw.reset();
        Draw.mixcol(!valid ? Pal.breakInvalid : Color.white, (!valid ? 0.4f : 0.24f) + Mathf.absin(Time.globalTime(), 6.0f, 0.28f));
        Draw.alpha(1.0f);
        this.drawRequestRegion(req, list);
        Draw.reset();
    }

    public void drawRequestRegion(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
        TextureRegion reg = this.icon(Cicon.full);
        Draw.rect(this.icon(Cicon.full), req.drawx(), req.drawy(), (float)reg.getWidth() * req.animScale * Draw.scl, (float)reg.getHeight() * req.animScale * Draw.scl, !this.rotate ? 0.0f : (float)(req.rotation * 90));
        if (req.hasConfig) {
            this.drawRequestConfig(req, list);
        }
    }

    public void drawRequestConfig(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
    }

    public void drawRequestConfigCenter(BuilderTrait.BuildRequest req, Content content, String region) {
        Color color;
        Color color2 = content instanceof Item ? ((Item)content).color : (color = content instanceof Liquid ? ((Liquid)content).color : null);
        if (color == null) {
            return;
        }
        Draw.color(color);
        Draw.scl *= req.animScale;
        Draw.rect(region, req.drawx(), req.drawy());
        Draw.scl /= req.animScale;
        Draw.color();
    }

    public void drawRequestConfigTop(BuilderTrait.BuildRequest req, Eachable<BuilderTrait.BuildRequest> list) {
    }

    @Override
    public void createIcons(PixmapPacker packer, PixmapPacker editor) {
        super.createIcons(packer, editor);
        editor.pack(this.name + "-icon-editor", Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icon(Cicon.full)).crop());
        if (!this.synthetic()) {
            PixmapRegion image = Core.atlas.getPixmap((TextureAtlas.AtlasRegion)this.icon(Cicon.full));
            this.color.set(image.getPixel(image.width / 2, image.height / 2));
        }
        this.getGeneratedIcons();
        Pixmap last = null;
        if (this.outlineIcon) {
            int radius = 4;
            PixmapRegion region = Core.atlas.getPixmap(this.getGeneratedIcons()[this.getGeneratedIcons().length - 1]);
            Pixmap out = new Pixmap(region.width, region.height);
            Color color = new Color();
            for (int x = 0; x < region.width; ++x) {
                for (int y = 0; y < region.height; ++y) {
                    region.getPixel(x, y, color);
                    out.draw(x, y, color);
                    if (!(color.a < 1.0f)) continue;
                    boolean found = false;
                    block2: for (int rx = -4; rx <= 4; ++rx) {
                        for (int ry = -4; ry <= 4; ++ry) {
                            if (!Structs.inBounds(rx + x, ry + y, region.width, region.height) || !(Mathf.dst2(rx, ry) <= 16.0f) || !(color.set((int)region.getPixel((int)(rx + x), (int)(ry + y))).a > 0.01f)) continue;
                            found = true;
                            break block2;
                        }
                    }
                    if (!found) continue;
                    out.draw(x, y, this.outlineColor);
                }
            }
            last = out;
            packer.pack(this.name, out);
        }
        if (this.generatedIcons.length > 1) {
            Pixmap base = Core.atlas.getPixmap(this.generatedIcons[0]).crop();
            for (int i = 1; i < this.generatedIcons.length; ++i) {
                if (i == this.generatedIcons.length - 1 && last != null) {
                    base.drawPixmap(last);
                    continue;
                }
                base.draw(Core.atlas.getPixmap(this.generatedIcons[i]));
            }
            packer.pack("block-" + this.name + "-full", base);
            this.generatedIcons = null;
            Arrays.fill(this.cicons, null);
        }
    }

    public TextureRegion editorIcon() {
        if (this.editorIcon == null) {
            this.editorIcon = Core.atlas.find(this.name + "-icon-editor");
        }
        return this.editorIcon;
    }

    public TextureRegion[] editorVariantRegions() {
        if (this.editorVariantRegions == null) {
            this.variantRegions();
            this.editorVariantRegions = new TextureRegion[this.variantRegions.length];
            for (int i = 0; i < this.variantRegions.length; ++i) {
                TextureAtlas.AtlasRegion region = (TextureAtlas.AtlasRegion)this.variantRegions[i];
                this.editorVariantRegions[i] = Core.atlas.find("editor-" + region.name);
            }
        }
        return this.editorVariantRegions;
    }

    protected TextureRegion[] generateIcons() {
        return new TextureRegion[]{Core.atlas.find(this.name)};
    }

    public TextureRegion[] getGeneratedIcons() {
        if (this.generatedIcons == null) {
            this.generatedIcons = this.generateIcons();
        }
        return this.generatedIcons;
    }

    public TextureRegion[] variantRegions() {
        if (this.variantRegions == null) {
            this.variantRegions = new TextureRegion[]{this.icon(Cicon.full)};
        }
        return this.variantRegions;
    }

    public boolean hasEntity() {
        return this.destructible || this.update;
    }

    public TileEntity newEntity() {
        return new TileEntity();
    }

    public float offset() {
        return (float)((this.size + 1) % 2 * 8) / 2.0f;
    }

    public Rectangle bounds(int x, int y, Rectangle rect) {
        return rect.setSize(this.size * 8).setCenter((float)(x * 8) + this.offset(), (float)(y * 8) + this.offset());
    }

    public boolean isMultiblock() {
        return this.size > 1;
    }

    public boolean isVisible() {
        return this.buildVisibility.visible() && !this.isHidden();
    }

    public boolean isFloor() {
        return this instanceof Floor;
    }

    public boolean isOverlay() {
        return this instanceof OverlayFloor;
    }

    public Floor asFloor() {
        return (Floor)this;
    }

    @Override
    public boolean isHidden() {
        return !this.buildVisibility.visible();
    }

    @Override
    public boolean alwaysUnlocked() {
        return this.alwaysUnlocked;
    }

    protected void requirements(Category cat, ItemStack[] stacks, boolean unlocked) {
        this.requirements(cat, BuildVisibility.shown, stacks);
        this.alwaysUnlocked = unlocked;
    }

    protected void requirements(Category cat, ItemStack[] stacks) {
        this.requirements(cat, BuildVisibility.shown, stacks);
    }

    protected void requirements(Category cat, BuildVisibility visible, ItemStack[] stacks) {
        this.category = cat;
        this.requirements = stacks;
        this.buildVisibility = visible;
        Arrays.sort(this.requirements, Structs.comparingInt(i -> i.item.id));
    }
}

