/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.layout;

import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.collection.Queue;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.ui.layout.TreeLayout;

public class RadialTreeLayout
implements TreeLayout {
    private static ObjectSet<TreeLayout.TreeNode> visited = new ObjectSet();
    private static Queue<TreeLayout.TreeNode> queue = new Queue();
    public float startRadius;
    public float delta;

    @Override
    public void layout(TreeLayout.TreeNode root) {
        this.startRadius = root.height * 2.4f;
        this.delta = root.height * 2.4f;
        this.bfs(root, true);
        this.radialize(root, 0.0f, 360.0f);
    }

    void radialize(TreeLayout.TreeNode root, float from, float to) {
        int depthOfVertex = root.number;
        float theta = from;
        float radius = this.startRadius + this.delta * (float)depthOfVertex;
        int leavesNumber = this.bfs(root, false);
        for (Object child : root.children) {
            int lambda = this.bfs((TreeLayout.TreeNode)child, false);
            float mi = theta + (float)lambda / (float)leavesNumber * (to - from);
            float x = radius * Mathf.cos((theta + mi) / 2.0f * ((float)Math.PI / 180));
            float y = radius * Mathf.sin((theta + mi) / 2.0f * ((float)Math.PI / 180));
            ((TreeLayout.TreeNode)child).x = x;
            ((TreeLayout.TreeNode)child).y = y;
            if (((TreeLayout.TreeNode)child).children.length > 0) {
                this.radialize((TreeLayout.TreeNode)child, theta, mi);
            }
            theta = mi;
        }
    }

    int bfs(TreeLayout.TreeNode node, boolean assign) {
        visited.clear();
        queue.clear();
        if (assign) {
            node.number = 0;
        }
        int leaves = 0;
        visited.add(node);
        queue.addFirst(node);
        while (!queue.isEmpty()) {
            TreeLayout.TreeNode current = queue.removeFirst();
            if (current.children.length == 0) {
                ++leaves;
            }
            for (Object child : current.children) {
                if (assign) {
                    ((TreeLayout.TreeNode)child).number = current.number + 1;
                }
                if (visited.contains((TreeLayout.TreeNode)child)) continue;
                visited.add((TreeLayout.TreeNode)child);
                queue.addLast((TreeLayout.TreeNode)child);
            }
        }
        return leaves;
    }
}

