/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.fragments;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.event.HandCursorListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.fragments.Fragment;
import io.anuke.mindustry.world.Tile;

public class BlockInventoryFragment
extends Fragment {
    private static final float holdWithdraw = 20.0f;
    private Table table = new Table();
    private Tile tile;
    private float holdTime = 0.0f;
    private boolean holding;
    private Item lastItem;

    public static void requestItem(Player player, Tile tile, Item item, int amount) {
        if (player == null || tile == null || !player.timer.get(4, 20.0f) || !tile.interactable(player.getTeam())) {
            return;
        }
        if (!Units.canInteract(player, tile)) {
            return;
        }
        int removed = tile.block().removeStack(tile, item, amount);
        player.addItem(item, removed);
        for (int j = 0; j < Mathf.clamp(removed / 3, 1, 8); ++j) {
            Time.run((float)j * 3.0f, () -> Call.transferItemEffect(item, tile.drawx(), tile.drawy(), player));
        }
    }

    @Override
    public void build(Group parent) {
        this.table.setName("inventory");
        this.table.setTransform(true);
        parent.setTransform(true);
        parent.addChild(this.table);
    }

    public void showFor(Tile t) {
        if (this.tile == t) {
            this.hide();
            return;
        }
        this.tile = t;
        if (this.tile == null || this.tile.entity == null || !this.tile.block().isAccessible() || this.tile.entity.items.total() == 0) {
            return;
        }
        this.rebuild(true);
    }

    public void hide() {
        if (this.table == null) {
            return;
        }
        this.table.actions(Actions.scaleTo(0.0f, 1.0f, 0.06f, Interpolation.pow3Out), Actions.run(() -> {
            this.table.clearChildren();
            this.table.clearListeners();
            this.table.update(null);
        }), Actions.visible(false));
        this.table.touchable(Touchable.disabled);
        this.tile = null;
    }

    private void rebuild(boolean actions) {
        IntSet container = new IntSet();
        this.table.clearChildren();
        this.table.clearActions();
        this.table.background(Tex.inventory);
        this.table.touchable(Touchable.enabled);
        this.table.update(() -> {
            if (Vars.state.is(GameState.State.menu) || this.tile == null || this.tile.entity == null || !this.tile.block().isAccessible() || this.tile.entity.items.total() == 0) {
                this.hide();
            } else {
                if (this.holding && this.lastItem != null) {
                    this.holdTime += Time.delta();
                    if (this.holdTime >= 20.0f) {
                        int amount = Math.min(this.tile.entity.items.get(this.lastItem), Vars.player.maxAccepted(this.lastItem));
                        Call.requestItem(Vars.player, this.tile, this.lastItem, amount);
                        this.holding = false;
                        this.holdTime = 0.0f;
                        Events.fire(new EventType.WithdrawEvent());
                    }
                }
                this.updateTablePosition();
                if (this.tile.block().hasItems) {
                    for (int i = 0; i < Vars.content.items().size; ++i) {
                        boolean has = this.tile.entity.items.has(Vars.content.item(i));
                        if (has == container.contains(i)) continue;
                        this.rebuild(false);
                    }
                }
            }
        });
        int cols = 3;
        int row = 0;
        this.table.margin(4.0f);
        this.table.defaults().size(40.0f).pad(4.0f);
        if (this.tile.block().hasItems) {
            for (int i = 0; i < Vars.content.items().size; ++i) {
                final Item item = Vars.content.item(i);
                if (!this.tile.entity.items.has(item)) continue;
                container.add(i);
                final BooleanProvider canPick = () -> Vars.player.acceptsItem(item) && !Vars.state.isPaused();
                HandCursorListener l = new HandCursorListener();
                l.setEnabled(canPick);
                Element image = this.itemImage(item.icon(Cicon.xlarge), () -> {
                    if (this.tile == null || this.tile.entity == null) {
                        return "";
                    }
                    return this.round(this.tile.entity.items.get(item));
                });
                image.addListener(l);
                image.addListener(new InputListener(){

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        if (!canPick.get() || BlockInventoryFragment.this.tile == null || ((BlockInventoryFragment)BlockInventoryFragment.this).tile.entity == null || ((BlockInventoryFragment)BlockInventoryFragment.this).tile.entity.items == null || !((BlockInventoryFragment)BlockInventoryFragment.this).tile.entity.items.has(item)) {
                            return false;
                        }
                        int amount = Math.min(1, Vars.player.maxAccepted(item));
                        if (amount > 0) {
                            Call.requestItem(Vars.player, BlockInventoryFragment.this.tile, item, amount);
                            BlockInventoryFragment.this.lastItem = item;
                            BlockInventoryFragment.this.holding = true;
                            BlockInventoryFragment.this.holdTime = 0.0f;
                            Events.fire(new EventType.WithdrawEvent());
                        }
                        return true;
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        BlockInventoryFragment.this.holding = false;
                        BlockInventoryFragment.this.lastItem = null;
                    }
                });
                this.table.add(image);
                if (row++ % cols != cols - 1) continue;
                this.table.row();
            }
        }
        if (row == 0) {
            this.table.setSize(0.0f, 0.0f);
        }
        this.updateTablePosition();
        this.table.visible(true);
        if (actions) {
            this.table.setScale(0.0f, 1.0f);
            this.table.actions(Actions.scaleTo(1.0f, 1.0f, 0.07f, Interpolation.pow3Out));
        } else {
            this.table.setScale(1.0f, 1.0f);
        }
    }

    private String round(float f) {
        if ((f = (float)((int)f)) >= 1000000.0f) {
            return (int)(f / 1000000.0f) + "[gray]mil[]";
        }
        if (f >= 1000.0f) {
            return (int)(f / 1000.0f) + "k";
        }
        return (int)f + "";
    }

    private void updateTablePosition() {
        Vector2 v = Core.input.mouseScreen(this.tile.drawx() + (float)(this.tile.block().size * 8) / 2.0f, this.tile.drawy() + (float)(this.tile.block().size * 8) / 2.0f);
        this.table.pack();
        this.table.setPosition(v.x, v.y, 10);
    }

    private Element itemImage(TextureRegion region, Supplier<CharSequence> text) {
        Stack stack = new Stack();
        Table t = new Table().left().bottom();
        t.label(text);
        stack.add(new Image(region));
        stack.add(t);
        return stack;
    }
}

