/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Objective;
import io.anuke.mindustry.game.Objectives;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.LoadoutDialog;

public class ZoneInfoDialog
extends FloatingDialog {
    private LoadoutDialog loadout = new LoadoutDialog();

    public ZoneInfoDialog() {
        super("");
        this.titleTable.remove();
        this.addCloseButton();
    }

    public void show(Zone zone) {
        this.setup(zone);
        this.show();
    }

    private void setup(Zone zone) {
        this.cont.clear();
        Table iteminfo = new Table();
        Runnable rebuildItems = () -> {
            int i = 0;
            iteminfo.clear();
            if (!zone.unlocked()) {
                return;
            }
            for (ItemStack stack : zone.getLaunchCost()) {
                if (stack.amount == 0) continue;
                if (i++ % 2 == 0) {
                    iteminfo.row();
                }
                iteminfo.addImage(stack.item.icon(Cicon.small)).size(24.0f).padRight(1.0f);
                iteminfo.add(stack.amount + "").color(Color.lightGray).padRight(5.0f);
            }
        };
        rebuildItems.run();
        this.cont.pane((Table cont) -> {
            if (zone.locked()) {
                cont.addImage(Icon.locked);
                cont.row();
                cont.add("$locked").padBottom(6.0f);
                cont.row();
                cont.table((Table req) -> {
                    req.defaults().left();
                    Array<Objective> zones = zone.requirements.select(o -> !(o instanceof Objectives.Unlock));
                    if (!zones.isEmpty()) {
                        req.table((Table r) -> {
                            r.add("$complete").colspan(2).left();
                            r.row();
                            for (Objective o : zones) {
                                r.addImage(Icon.terrain).padRight(4.0f);
                                r.add(o.display()).color(Color.lightGray);
                                r.addImage(o.complete() ? Icon.checkSmall : Icon.cancelSmall, o.complete() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                                r.row();
                            }
                        });
                    }
                    req.row();
                    Array<Objectives.Unlock> blocks = zone.requirements.select(o -> o instanceof Objectives.Unlock).as(Objectives.Unlock.class);
                    if (!blocks.isEmpty()) {
                        req.table((Table r) -> {
                            r.add("$research.list").colspan(2).left();
                            r.row();
                            for (Objectives.Unlock blocko : blocks) {
                                r.addImage(blocko.block.icon(Cicon.small)).size(24.0f).padRight(5.0f);
                                r.add(blocko.block.localizedName).color(Color.lightGray).left();
                                r.addImage(blocko.block.unlocked() ? Icon.checkSmall : Icon.cancelSmall, blocko.block.unlocked() ? Color.lightGray : Color.scarlet).padLeft(3.0f);
                                r.row();
                            }
                        }).padTop(10.0f);
                    }
                }).growX();
            } else {
                cont.add(zone.localizedName()).color(Pal.accent).growX().center();
                cont.row();
                cont.addImage().color(Pal.accent).height(3.0f).pad(6.0f).growX();
                cont.row();
                cont.table((Table desc) -> {
                    desc.left().defaults().left().width(Core.graphics.isPortrait() ? 350.0f : 500.0f);
                    desc.pane((Table t) -> t.marginRight(12.0f).add(zone.description).wrap().growX()).fillX().maxHeight(Vars.mobile ? 300.0f : 450.0f).pad(2.0f).padBottom(8.0f).get().setScrollingDisabled(true, false);
                    desc.row();
                    desc.table((Table t) -> {
                        t.left();
                        t.add("$zone.resources").padRight(6.0f);
                        if (zone.resources.size > 0) {
                            t.table((Table r) -> {
                                t.left();
                                int i = 0;
                                for (Item item : zone.resources) {
                                    r.addImage(item.icon(Cicon.small)).size(24.0f);
                                    if (++i % 4 != 0) continue;
                                    r.row();
                                }
                            });
                        } else {
                            t.add("$none");
                        }
                    });
                    Rules rules = zone.getRules();
                    desc.row();
                    desc.add(Core.bundle.format("zone.objective", Core.bundle.get(!rules.attackMode ? "zone.objective.survival" : "zone.objective.attack")));
                    if (zone.bestWave() > 0) {
                        desc.row();
                        desc.add(Core.bundle.format("bestwave", zone.bestWave()));
                    }
                });
                cont.row();
            }
            cont.marginRight(12.0f);
        });
        this.cont.row();
        this.cont.addButton(zone.canConfigure() ? "$configure" : Core.bundle.format("configure.locked", zone.configureObjective.display()), () -> this.loadout.show(zone.loadout.core().itemCapacity, zone.getStartingItems(), zone::resetStartingItems, zone::updateLaunchCost, rebuildItems)).fillX().pad(3.0f).disabled(b -> !zone.canConfigure());
        this.cont.row();
        Button button = this.cont.addButton(zone.locked() ? "$uncover" : "$launch", () -> {
            if (!Vars.data.isUnlocked(zone)) {
                Sounds.unlock.play();
                Vars.data.unlockContent(zone);
                Vars.ui.deploy.setup();
                this.setup(zone);
            } else {
                Vars.ui.deploy.hide();
                Vars.data.removeItems(zone.getLaunchCost());
                this.hide();
                Vars.control.playZone(zone);
            }
        }).minWidth(200.0f).margin(13.0f).padTop(5.0f).disabled(b -> zone.locked() ? !zone.canUnlock() : !Vars.data.hasItems(zone.getLaunchCost())).uniformY().get();
        button.row();
        button.add(iteminfo);
    }
}

