/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.Group;
import io.anuke.arc.scene.actions.Actions;
import io.anuke.arc.scene.actions.RelativeTemporalAction;
import io.anuke.arc.scene.event.ElementGestureListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.TechTree;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.ItemsDisplay;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.layout.RadialTreeLayout;
import io.anuke.mindustry.ui.layout.TreeLayout;

public class TechTreeDialog
extends FloatingDialog {
    private final float nodeSize = Scl.scl(60.0f);
    private ObjectSet<TechTreeNode> nodes = new ObjectSet();
    private TechTreeNode root = new TechTreeNode(TechTree.root, null);
    private Rectangle bounds = new Rectangle();
    private ItemsDisplay items;
    private View view;

    public TechTreeDialog() {
        super("");
        this.titleTable.remove();
        this.margin(0.0f).marginBottom(8.0f);
        Element[] elementArray = new Element[2];
        this.view = new View();
        elementArray[0] = this.view;
        this.items = new ItemsDisplay();
        elementArray[1] = this.items;
        Stack stack = this.cont.stack(elementArray).grow().get();
        Events.on(EventType.ContentReloadEvent.class, e -> {
            this.nodes.clear();
            this.root = new TechTreeNode(TechTree.root, null);
            this.checkNodes(this.root);
            this.treeLayout();
            ((Element)stack.getChildren().get(0)).remove();
            this.view = new View();
            stack.addChildAt(0, this.view);
        });
        this.shown(() -> {
            this.checkNodes(this.root);
            this.treeLayout();
        });
        this.hidden(Vars.ui.deploy::setup);
        this.addCloseButton();
        this.buttons.addImageTextButton("$database", Icon.database, () -> {
            this.hide();
            Vars.ui.database.show();
        }).size(210.0f, 64.0f);
        this.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
                TechTreeDialog.this.view.setScale(Mathf.clamp(TechTreeDialog.this.view.getScaleX() - amountY / 40.0f, 0.25f, 1.0f));
                TechTreeDialog.this.view.setOrigin(1);
                TechTreeDialog.this.view.setTransform(true);
                return true;
            }

            @Override
            public boolean mouseMoved(InputEvent event, float x, float y) {
                TechTreeDialog.this.view.requestScroll();
                return super.mouseMoved(event, x, y);
            }
        });
        this.addListener(new ElementGestureListener(){

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (((TechTreeDialog)TechTreeDialog.this).view.lastZoom < 0.0f) {
                    ((TechTreeDialog)TechTreeDialog.this).view.lastZoom = TechTreeDialog.this.view.getScaleX();
                }
                TechTreeDialog.this.view.setScale(Mathf.clamp(distance / initialDistance * ((TechTreeDialog)TechTreeDialog.this).view.lastZoom, 0.25f, 1.0f));
                TechTreeDialog.this.view.setOrigin(1);
                TechTreeDialog.this.view.setTransform(true);
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                ((TechTreeDialog)TechTreeDialog.this).view.lastZoom = TechTreeDialog.this.view.getScaleX();
            }

            @Override
            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                ((TechTreeDialog)TechTreeDialog.this).view.panX += deltaX / TechTreeDialog.this.view.getScaleX();
                ((TechTreeDialog)TechTreeDialog.this).view.panY += deltaY / TechTreeDialog.this.view.getScaleY();
                ((TechTreeDialog)TechTreeDialog.this).view.moved = true;
                TechTreeDialog.this.view.clamp();
            }
        });
    }

    void treeLayout() {
        RadialTreeLayout layout = new RadialTreeLayout();
        LayoutNode node = new LayoutNode(this.root, null);
        layout.layout(node);
        float minx = 0.0f;
        float miny = 0.0f;
        float maxx = 0.0f;
        float maxy = 0.0f;
        this.copyInfo(node);
        for (TechTreeNode n : this.nodes) {
            if (!n.visible) continue;
            minx = Math.min(n.x - n.width / 2.0f, minx);
            maxx = Math.max(n.x + n.width / 2.0f, maxx);
            miny = Math.min(n.y - n.height / 2.0f, miny);
            maxy = Math.max(n.y + n.height / 2.0f, maxy);
        }
        this.bounds = new Rectangle(minx, miny, maxx - minx, maxy - miny);
        this.bounds.y += this.nodeSize * 1.5f;
    }

    void copyInfo(LayoutNode node) {
        node.node.x = node.x;
        node.node.y = node.y;
        if (node.children != null) {
            for (LayoutNode child : (LayoutNode[])node.children) {
                this.copyInfo(child);
            }
        }
    }

    void checkNodes(TechTreeNode node) {
        boolean locked = this.locked(node.node);
        if (!locked) {
            node.visible = true;
        }
        for (TechTreeNode l : (TechTreeNode[])node.children) {
            l.visible = !locked;
            this.checkNodes(l);
        }
        this.items.rebuild();
    }

    void showToast(String info) {
        Table table = new Table();
        table.actions(Actions.fadeOut(0.5f, Interpolation.fade), Actions.remove());
        table.top().add(info);
        table.setName("toast");
        table.update(() -> {
            table.toFront();
            table.setPosition((float)Core.graphics.getWidth() / 2.0f, Core.graphics.getHeight() - 21, 2);
        });
        Core.scene.add(table);
    }

    boolean locked(TechTree.TechNode node) {
        return node.block.locked();
    }

    class View
    extends Group {
        float panX = 0.0f;
        float panY = -200.0f;
        float lastZoom = -1.0f;
        boolean moved = false;
        ImageButton hoverNode;
        Table infoTable = new Table();

        View() {
            this.infoTable.touchable(Touchable.enabled);
            for (TechTreeNode node : TechTreeDialog.this.nodes) {
                ImageButton button = new ImageButton(node.node.block.icon(Cicon.medium), Styles.nodei);
                button.visible(() -> node.visible);
                button.clicked(() -> {
                    if (this.moved) {
                        return;
                    }
                    if (Vars.mobile) {
                        this.hoverNode = button;
                        this.rebuild();
                        float right = this.infoTable.getRight();
                        if (right > (float)Core.graphics.getWidth()) {
                            final float moveBy = right - (float)Core.graphics.getWidth();
                            this.addAction(new RelativeTemporalAction(){
                                {
                                    this.setDuration(0.1f);
                                    this.setInterpolation(Interpolation.fade);
                                }

                                @Override
                                protected void updateRelative(float percentDelta) {
                                    View.this.panX -= moveBy * percentDelta;
                                }
                            });
                        }
                    } else if (Vars.data.hasItems(node.node.requirements) && TechTreeDialog.this.locked(node.node)) {
                        this.unlock(node.node);
                    }
                });
                button.hovered(() -> {
                    if (!Vars.mobile && this.hoverNode != button && node.visible) {
                        this.hoverNode = button;
                        this.rebuild();
                    }
                });
                button.exited(() -> {
                    if (!(Vars.mobile || this.hoverNode != button || this.infoTable.hasMouse() || this.hoverNode.hasMouse())) {
                        this.hoverNode = null;
                        this.rebuild();
                    }
                });
                button.touchable(() -> !node.visible ? Touchable.disabled : Touchable.enabled);
                button.setUserObject(node.node);
                button.setSize(TechTreeDialog.this.nodeSize);
                button.update(() -> {
                    float offset = (float)(Core.graphics.getHeight() % 2) / 2.0f;
                    button.setPosition(node.x + this.panX + this.width / 2.0f, node.y + this.panY + this.height / 2.0f + offset, 1);
                    button.getStyle().up = !TechTreeDialog.this.locked(node.node) ? Tex.buttonOver : (!Vars.data.hasItems(node.node.requirements) ? Tex.buttonRed : Tex.button);
                    ((TextureRegionDrawable)button.getStyle().imageUp).setRegion(node.visible ? node.node.block.icon(Cicon.medium) : Core.atlas.find("icon-locked"));
                    button.getImage().setColor(!TechTreeDialog.this.locked(node.node) ? Color.white : Color.gray);
                });
                this.addChild(button);
            }
            if (Vars.mobile) {
                this.tapped(() -> {
                    Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
                    if (e == this) {
                        this.hoverNode = null;
                        this.rebuild();
                    }
                });
            }
            this.setOrigin(1);
            this.setTransform(true);
            this.released(() -> {
                this.moved = false;
            });
        }

        void clamp() {
            float pad = TechTreeDialog.this.nodeSize;
            float ox = this.width / 2.0f;
            float oy = this.height / 2.0f;
            float rx = ((TechTreeDialog)TechTreeDialog.this).bounds.x + this.panX + ox;
            float ry = this.panY + oy + ((TechTreeDialog)TechTreeDialog.this).bounds.y;
            float rw = ((TechTreeDialog)TechTreeDialog.this).bounds.width;
            float rh = ((TechTreeDialog)TechTreeDialog.this).bounds.height;
            rx = Mathf.clamp(rx, -rw + pad, (float)Core.graphics.getWidth() - pad);
            ry = Mathf.clamp(ry, -rh + pad, (float)Core.graphics.getHeight() - pad);
            this.panX = rx - ((TechTreeDialog)TechTreeDialog.this).bounds.x - ox;
            this.panY = ry - ((TechTreeDialog)TechTreeDialog.this).bounds.y - oy;
        }

        void unlock(TechTree.TechNode node) {
            Vars.data.unlockContent(node.block);
            Vars.data.removeItems(node.requirements);
            TechTreeDialog.this.showToast(Core.bundle.format("researched", node.block.localizedName));
            TechTreeDialog.this.checkNodes(TechTreeDialog.this.root);
            this.hoverNode = null;
            TechTreeDialog.this.treeLayout();
            this.rebuild();
            Core.scene.act();
            Sounds.unlock.play();
            Events.fire(new EventType.ResearchEvent(node.block));
        }

        void rebuild() {
            ImageButton button = this.hoverNode;
            this.infoTable.remove();
            this.infoTable.clear();
            this.infoTable.update(null);
            if (button == null) {
                return;
            }
            TechTree.TechNode node = (TechTree.TechNode)button.getUserObject();
            this.infoTable.exited(() -> {
                if (this.hoverNode == button && !this.infoTable.hasMouse() && !this.hoverNode.hasMouse()) {
                    this.hoverNode = null;
                    this.rebuild();
                }
            });
            this.infoTable.update(() -> this.infoTable.setPosition(button.getX() + button.getWidth(), button.getY() + button.getHeight(), 10));
            this.infoTable.left();
            this.infoTable.background(Tex.button).margin(8.0f);
            this.infoTable.table(b -> {
                b.margin(0.0f).left().defaults().left();
                b.addImageButton((Drawable)Icon.infoSmall, Styles.cleari, () -> Vars.ui.content.show(node.block)).growY().width(50.0f);
                b.add().grow();
                b.table(desc -> {
                    desc.left().defaults().left();
                    desc.add(node.block.localizedName);
                    desc.row();
                    if (TechTreeDialog.this.locked(node)) {
                        desc.table(t -> {
                            t.left();
                            for (ItemStack req : node.requirements) {
                                t.table(list -> {
                                    list.left();
                                    list.addImage(req.item.icon(Cicon.small)).size(24.0f).padRight(3.0f);
                                    list.add(req.item.localizedName()).color(Color.lightGray);
                                    list.label(() -> " " + Math.min(Vars.data.getItem(req.item), req.amount) + " / " + req.amount).update((T l) -> l.setColor(Vars.data.has(req.item, req.amount) ? Color.lightGray : Color.scarlet));
                                }).fillX().left();
                                t.row();
                            }
                        });
                    } else {
                        desc.add("$completed");
                    }
                }).pad(9.0f);
                if (Vars.mobile && TechTreeDialog.this.locked(node)) {
                    b.row();
                    b.addImageTextButton("$research", (Drawable)Icon.checkSmall, Styles.nodet, () -> this.unlock(node)).disabled(i -> !Vars.data.hasItems(node.requirements)).growX().height(44.0f).colspan(3);
                }
            });
            this.infoTable.row();
            if (node.block.description != null) {
                this.infoTable.table(t -> t.margin(3.0f).left().labelWrap(node.block.description).color(Color.lightGray).growX()).fillX();
            }
            this.addChild(this.infoTable);
            this.infoTable.pack();
            this.infoTable.act(Core.graphics.getDeltaTime());
        }

        @Override
        public void drawChildren() {
            this.clamp();
            float offsetX = this.panX + this.width / 2.0f;
            float offsetY = this.panY + this.height / 2.0f;
            for (TechTreeNode node : TechTreeDialog.this.nodes) {
                if (!node.visible) continue;
                for (TechTreeNode child : (TechTreeNode[])node.children) {
                    if (!child.visible) continue;
                    Lines.stroke(Scl.scl(4.0f), TechTreeDialog.this.locked(node.node) || TechTreeDialog.this.locked(child.node) ? Pal.gray : Pal.accent);
                    Draw.alpha(this.parentAlpha);
                    Lines.line(node.x + offsetX, node.y + offsetY, child.x + offsetX, child.y + offsetY);
                }
            }
            Draw.reset();
            super.drawChildren();
        }
    }

    class TechTreeNode
    extends TreeLayout.TreeNode<TechTreeNode> {
        final TechTree.TechNode node;
        boolean visible = true;

        TechTreeNode(TechTree.TechNode node, TechTreeNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = TechTreeDialog.this.nodeSize;
            TechTreeDialog.this.nodes.add(this);
            if (node.children != null) {
                this.children = new TechTreeNode[node.children.size];
                for (int i = 0; i < ((TechTreeNode[])this.children).length; ++i) {
                    ((TechTreeNode[])this.children)[i] = new TechTreeNode(node.children.get(i), this);
                }
            }
        }
    }

    class LayoutNode
    extends TreeLayout.TreeNode<LayoutNode> {
        final TechTreeNode node;

        LayoutNode(TechTreeNode node, LayoutNode parent) {
            this.node = node;
            this.parent = parent;
            this.width = this.height = TechTreeDialog.this.nodeSize;
            if (node.children != null) {
                this.children = (TreeLayout.TreeNode[])Array.with(node.children).map(t -> new LayoutNode((TechTreeNode)t, this)).toArray(LayoutNode.class);
            }
        }
    }
}

