/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.Button;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Schematic;
import io.anuke.mindustry.game.Schematics;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class SchematicsDialog
extends FloatingDialog {
    private SchematicInfoDialog info = new SchematicInfoDialog();
    private String search = "";

    public SchematicsDialog() {
        super("$schematics");
        Core.assets.load((String)"sprites/schematic-background.png", Texture.class).loaded = t -> ((Texture)t).setWrap(Texture.TextureWrap.Repeat);
        this.shouldPause = true;
        this.addCloseButton();
        this.buttons.addImageTextButton("$schematic.import", Icon.loadMapSmall, this::showImport);
        this.shown(this::setup);
    }

    void setup() {
        this.search = "";
        Runnable[] rebuildPane = new Runnable[]{null};
        this.cont.top();
        this.cont.clear();
        this.cont.table((Table s) -> {
            s.left();
            s.addImage(Icon.zoom);
            s.addField(this.search, res -> {
                this.search = res;
                rebuildPane[0].run();
            }).growX();
        }).fillX().padBottom(4.0f);
        this.cont.row();
        this.cont.pane((Table t) -> {
            t.top();
            t.margin(20.0f);
            rebuildPane[0] = () -> {
                t.clear();
                int i = 0;
                if (!Vars.schematics.all().contains((Schematic)((Object)((Predicate<Schematic>)s -> this.search.isEmpty() || s.name().contains(this.search))))) {
                    t.add("$none");
                }
                for (Schematic s2 : Vars.schematics.all()) {
                    if (!this.search.isEmpty() && !s2.name().contains(this.search)) continue;
                    Button[] sel = new Button[]{null};
                    sel[0] = t.addButton((Button b) -> {
                        b.top();
                        b.margin(0.0f);
                        b.table((Table buttons) -> {
                            buttons.left();
                            buttons.defaults().size(50.0f);
                            ImageButton.ImageButtonStyle style = Styles.clearPartiali;
                            buttons.addImageButton((Drawable)Icon.infoSmall, style, () -> this.showInfo(s2));
                            buttons.addImageButton((Drawable)Icon.loadMapSmall, style, () -> this.showExport(s2));
                            buttons.addImageButton((Drawable)Icon.pencilSmall, style, () -> Vars.ui.showTextInput("$schematic.rename", "$name", s2.name(), res -> {
                                s.tags.put("name", res);
                                s2.save();
                                rebuildPane[0].run();
                            }));
                            if (s2.hasSteamID()) {
                                buttons.addImageButton((Drawable)Icon.linkSmall, style, () -> Vars.platform.viewListing(s2));
                            } else {
                                buttons.addImageButton((Drawable)Icon.trash16Small, style, () -> Vars.ui.showConfirm("$confirm", "$schematic.delete.confirm", () -> {
                                    Vars.schematics.remove(s2);
                                    rebuildPane[0].run();
                                }));
                            }
                        }).growX().height(50.0f);
                        b.row();
                        b.stack(new SchematicImage(s2).setScaling(Scaling.fit), new Table(n -> {
                            n.top();
                            n.table(Styles.black3, c -> {
                                Label label = c.add(s2.name()).style(Styles.outlineLabel).color(Color.white).top().growX().maxWidth(192.0f).get();
                                label.setEllipsis(true);
                                label.setAlignment(1);
                            }).growX().margin(1.0f).pad(4.0f).maxWidth(192.0f).padBottom(0.0f);
                        })).size(200.0f);
                    }, () -> {
                        if (sel[0].childrenPressed()) {
                            return;
                        }
                        Vars.control.input.useSchematic(s2);
                        this.hide();
                    }).pad(4.0f).style(Styles.cleari).get();
                    sel[0].getStyle().up = Tex.pane;
                    if (++i % 4 != 0) continue;
                    t.row();
                }
            };
            rebuildPane[0].run();
        }).get().setScrollingDisabled(true, false);
    }

    public void showInfo(Schematic schematic) {
        this.info.show(schematic);
    }

    public void showImport() {
        FloatingDialog dialog = new FloatingDialog("$editor.export");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 60.0f).left();
                t.row();
                t.addImageTextButton("$schematic.copy.import", (Drawable)Icon.copySmall, style, () -> {
                    dialog.hide();
                    try {
                        Schematic s = Vars.schematics.readBase64(Core.app.getClipboardText());
                        Vars.schematics.add(s);
                        this.setup();
                        Vars.ui.showInfoFade("$schematic.saved");
                        this.showInfo(s);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("bXNjaAB"));
                t.row();
                t.addImageTextButton("$schematic.importfile", (Drawable)Icon.saveMapSmall, style, () -> Vars.platform.showFileChooser(true, "msch", file -> {
                    dialog.hide();
                    try {
                        Schematic s = Schematics.read(file);
                        Vars.schematics.add(s);
                        this.setup();
                        this.showInfo(s);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                })).marginLeft(12.0f);
                t.row();
                if (Vars.steam) {
                    t.addImageTextButton("$schematic.browseworkshop", (Drawable)Icon.wikiSmall, style, () -> {
                        dialog.hide();
                        Vars.platform.openWorkshop();
                    }).marginLeft(12.0f);
                }
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void showExport(Schematic s) {
        FloatingDialog dialog = new FloatingDialog("$editor.export");
        dialog.cont.pane((Table p) -> {
            p.margin(10.0f);
            p.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.cleart;
                t.defaults().size(280.0f, 60.0f).left();
                if (Vars.steam && !s.hasSteamID()) {
                    t.addImageTextButton("$schematic.shareworkshop", (Drawable)Icon.wikiSmall, style, () -> Vars.platform.publish(s)).marginLeft(12.0f);
                    t.row();
                    dialog.hide();
                }
                t.addImageTextButton("$schematic.copy", (Drawable)Icon.copySmall, style, () -> {
                    dialog.hide();
                    Vars.ui.showInfoFade("$copied");
                    Core.app.setClipboardText(Vars.schematics.writeBase64(s));
                }).marginLeft(12.0f);
                t.row();
                t.addImageTextButton("$schematic.exportfile", (Drawable)Icon.saveMapSmall, style, () -> Vars.platform.showFileChooser(false, "msch", file -> {
                    dialog.hide();
                    try {
                        Schematics.write(s, file);
                    }
                    catch (Exception e) {
                        Vars.ui.showException(e);
                    }
                })).marginLeft(12.0f);
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public static class SchematicInfoDialog
    extends FloatingDialog {
        SchematicInfoDialog() {
            super("");
            this.setFillParent(true);
            this.addCloseButton();
        }

        public void show(Schematic schem) {
            this.cont.clear();
            this.title.setText("[[" + Core.bundle.get("schematic") + "] " + schem.name());
            this.cont.add(Core.bundle.format("schematic.info", schem.width, schem.height, schem.tiles.size)).color(Color.lightGray);
            this.cont.row();
            this.cont.add(new SchematicImage(schem)).maxSize(800.0f);
            this.cont.row();
            Array<ItemStack> arr = schem.requirements();
            this.cont.table((Table r) -> {
                int i = 0;
                for (ItemStack s : arr) {
                    r.addImage(s.item.icon(Cicon.small)).left();
                    r.add(s.amount + "").padLeft(2.0f).left().color(Color.lightGray).padRight(4.0f);
                    if (++i % 4 != 0) continue;
                    r.row();
                }
            });
            this.show();
        }
    }

    public static class SchematicImage
    extends Image {
        public float scaling = 16.0f;
        public float thickness = 4.0f;
        public Color borderColor = Pal.gray;
        private Schematic schematic;
        boolean set;

        public SchematicImage(Schematic s) {
            super(Tex.clear);
            this.setScaling(Scaling.fit);
            this.schematic = s;
            if (Vars.schematics.hasPreview(s)) {
                this.setPreview();
                this.set = true;
            }
        }

        @Override
        public void draw() {
            boolean checked = this.getParent().getParent() instanceof Button && ((Button)this.getParent().getParent()).isOver();
            boolean wasSet = this.set;
            if (!this.set) {
                Core.app.post(this::setPreview);
                this.set = true;
            }
            Texture background = Core.assets.get("sprites/schematic-background.png", Texture.class);
            TextureRegion region = Draw.wrap(background);
            float xr = this.width / this.scaling;
            float yr = this.height / this.scaling;
            region.setU2(xr);
            region.setV2(yr);
            Draw.color();
            Draw.alpha(this.parentAlpha);
            Draw.rect(region, this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
            if (wasSet) {
                super.draw();
            } else {
                Draw.rect(Icon.loading.getRegion(), this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width / 4.0f, this.height / 4.0f);
            }
            Draw.color(checked ? Pal.accent : this.borderColor);
            Draw.alpha(this.parentAlpha);
            Lines.stroke(Scl.scl(this.thickness));
            Lines.rect(this.x, this.y, this.width, this.height);
            Draw.reset();
        }

        private void setPreview() {
            TextureRegionDrawable draw = new TextureRegionDrawable(new TextureRegion(Vars.schematics.getPreview(this.schematic)));
            this.setDrawable(draw);
            this.setScaling(Scaling.fit);
        }
    }
}

