/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.input.KeyCode;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.LoadDialog;
import io.anuke.mindustry.ui.dialogs.SaveDialog;

public class PausedDialog
extends FloatingDialog {
    private SaveDialog save = new SaveDialog();
    private LoadDialog load = new LoadDialog();
    private boolean wasClient = false;

    public PausedDialog() {
        super("$menu");
        this.shouldPause = true;
        this.shown(this::rebuild);
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                this.hide();
            }
        });
    }

    void rebuild() {
        this.cont.clear();
        this.update(() -> {
            if (Vars.state.is(GameState.State.menu) && this.isShown()) {
                this.hide();
            }
        });
        if (!Vars.mobile) {
            float dw = 210.0f;
            this.cont.defaults().width(dw).height(50.0f).pad(5.0f);
            this.cont.addButton("$back", this::hide).colspan(2).width(dw * 2.0f + 20.0f);
            this.cont.row();
            if (Vars.world.isZone()) {
                this.cont.addButton("$techtree", Vars.ui.tech::show);
            } else {
                this.cont.addButton("$database", Vars.ui.database::show);
            }
            this.cont.addButton("$settings", Vars.ui.settings::show);
            if (!Vars.state.rules.tutorial) {
                if (!Vars.world.isZone() && !Vars.state.isEditor()) {
                    this.cont.row();
                    this.cont.addButton("$savegame", this.save::show);
                    this.cont.addButton("$loadgame", this.load::show).disabled(b -> Vars.net.active());
                }
                this.cont.row();
                this.cont.addButton("$hostserver", () -> {
                    if (Vars.net.server() && Vars.steam) {
                        Vars.platform.inviteFriends();
                    } else if (Vars.steam) {
                        Vars.ui.host.runHost();
                    } else {
                        Vars.ui.host.show();
                    }
                }).disabled(b -> (!Vars.steam || !Vars.net.server()) && Vars.net.active()).colspan(2).width(dw * 2.0f + 20.0f).update((T e) -> e.setText(Vars.net.server() && Vars.steam ? "$invitefriends" : "$hostserver"));
            }
            this.cont.row();
            this.cont.addButton("$quit", this::showQuitConfirm).colspan(2).width(dw + 10.0f).update((T s) -> s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "$save.quit" : "$quit"));
        } else {
            this.cont.defaults().size(130.0f).pad(5.0f);
            this.cont.addRowImageTextButton("$back", Icon.play2, this::hide);
            this.cont.addRowImageTextButton("$settings", Icon.tools, Vars.ui.settings::show);
            if (!Vars.world.isZone() && !Vars.state.isEditor()) {
                this.cont.addRowImageTextButton("$save", Icon.save, this.save::show);
                this.cont.row();
                this.cont.addRowImageTextButton("$load", Icon.load, this.load::show).disabled(b -> Vars.net.active());
            } else {
                this.cont.row();
            }
            this.cont.addRowImageTextButton("$hostserver.mobile", Icon.host, Vars.ui.host::show).disabled(b -> Vars.net.active());
            this.cont.addRowImageTextButton("$quit", Icon.quit, this::showQuitConfirm).update((T s) -> s.setText(Vars.control.saves.getCurrent() != null && Vars.control.saves.getCurrent().isAutosave() ? "$save.quit" : "$quit"));
        }
    }

    void showQuitConfirm() {
        Vars.ui.showConfirm("$confirm", Vars.state.rules.tutorial ? "$quit.confirm.tutorial" : "$quit.confirm", () -> {
            if (Vars.state.rules.tutorial) {
                Core.settings.put("playedtutorial", true);
                Core.settings.save();
            }
            this.wasClient = Vars.net.client();
            if (Vars.net.client()) {
                Vars.netClient.disconnectQuietly();
            }
            this.runExitSave();
            this.hide();
        });
    }

    public void runExitSave() {
        if (Vars.state.isEditor() && !this.wasClient) {
            Vars.ui.editor.resumeEditing();
            return;
        }
        if (Vars.control.saves.getCurrent() == null || !Vars.control.saves.getCurrent().isAutosave() || Vars.state.rules.tutorial || this.wasClient) {
            Vars.state.set(GameState.State.menu);
            Vars.logic.reset();
            return;
        }
        Vars.ui.loadAnd("$saveload", () -> {
            try {
                Vars.control.saves.getCurrent().save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
            Vars.state.set(GameState.State.menu);
            Vars.logic.reset();
        });
    }
}

