/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Net;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.io.Streams;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import java.io.IOException;

public class ModsDialog
extends FloatingDialog {
    public ModsDialog() {
        super("$mods");
        this.addCloseButton();
        this.buttons.addImageTextButton("$mods.report", Icon.link, () -> Core.net.openURI("https://github.com/Anuken/Mindustry/issues/new?template=bug_report.md")).size(250.0f, 64.0f);
        this.buttons.row();
        this.buttons.addImageTextButton("$mods.guide", Icon.wiki, () -> Core.net.openURI("https://mindustrygame.github.io/wiki/modding/")).size(210.0f, 64.0f);
        this.buttons.addImageTextButton("$mod.import.github", Icon.github, () -> Vars.ui.showTextInput("$mod.import.github", "", 64, "Anuken/ExampleMod", text -> {
            Vars.ui.loadfrag.show();
            Core.net.httpGet("http://api.github.com/repos/" + text + "/zipball/master", loc -> Core.net.httpGet(loc.getHeader("Location"), result -> {
                if (result.getStatus() != Net.HttpStatus.OK) {
                    Vars.ui.showErrorMessage(Core.bundle.format("connectfail", new Object[]{result.getStatus()}));
                    Vars.ui.loadfrag.hide();
                } else {
                    try {
                        FileHandle file = Vars.tmpDirectory.child(text.replace("/", "") + ".zip");
                        Streams.copyStream(result.getResultAsStream(), file.write(false));
                        Vars.mods.importMod(file);
                        file.delete();
                        Core.app.post(() -> {
                            try {
                                Vars.mods.reloadContent();
                                this.setup();
                                Vars.ui.loadfrag.hide();
                            }
                            catch (Throwable e) {
                                Vars.ui.showException(e);
                            }
                        });
                    }
                    catch (Throwable e) {
                        Vars.ui.showException(e);
                    }
                }
            }, t -> Core.app.post(() -> Vars.ui.showException((Throwable)t))), t -> Core.app.post(() -> Vars.ui.showException((Throwable)t)));
        })).size(250.0f, 64.0f);
        this.shown(this::setup);
        this.hidden(() -> {
            if (Vars.mods.requiresReload()) {
                Vars.ui.loadAnd("$reloading", () -> Vars.mods.reloadContent());
            }
        });
        this.shown(() -> Core.app.post(() -> Core.settings.getBoolOnce("modsalpha", () -> Vars.ui.showText("$mods", "$mods.alphainfo"))));
    }

    void setup() {
        this.cont.clear();
        this.cont.defaults().width(520.0f).pad(4.0f);
        this.cont.add("$mod.reloadrequired").visible(Vars.mods::requiresReload).center().get().setAlignment(1);
        this.cont.row();
        if (!Vars.mods.all().isEmpty() || !Vars.mods.disabled().isEmpty()) {
            this.cont.pane((Table table) -> {
                table.margin(10.0f).top();
                Array<Mods.LoadedMod> all = Array.withArrays(Vars.mods.all(), Vars.mods.disabled());
                boolean anyDisabled = false;
                for (Mods.LoadedMod mod : all) {
                    if (!mod.enabled() && !anyDisabled && Vars.mods.all().size > 0) {
                        anyDisabled = true;
                        table.row();
                        table.addImage().growX().height(4.0f).pad(6.0f).color(Pal.gray);
                        table.row();
                    }
                    table.table(Styles.black6, t -> {
                        t.defaults().pad(2.0f).left().top();
                        t.margin(14.0f).left();
                        t.table((Table title) -> {
                            title.left();
                            title.add("[accent]" + mod.meta.name + "[lightgray] v" + mod.meta.version + " | " + Core.bundle.get(mod.enabled() ? "mod.enabled" : "mod.disabled")).width(270.0f).wrap();
                            title.add().growX();
                            title.addImageTextButton(mod.enabled() ? "$mod.disable" : "$mod.enable", (Drawable)(mod.enabled() ? Icon.arrowDownSmall : Icon.arrowUpSmall), Styles.cleart, () -> {
                                Vars.mods.setEnabled(mod, !mod.enabled());
                                this.setup();
                            }).height(50.0f).margin(8.0f).width(130.0f);
                            if (Vars.steam && !mod.hasSteamID()) {
                                title.addImageButton((Drawable)Icon.loadMapSmall, Styles.cleari, () -> Vars.platform.publish(mod)).size(50.0f);
                            }
                            title.addImageButton((Drawable)(mod.hasSteamID() ? Icon.linkSmall : Icon.trash16Small), Styles.cleari, () -> {
                                if (!mod.hasSteamID()) {
                                    Vars.ui.showConfirm("$confirm", "$mod.remove.confirm", () -> {
                                        Vars.mods.removeMod(mod);
                                        this.setup();
                                    });
                                } else {
                                    Vars.platform.viewListing(mod);
                                }
                            }).size(50.0f);
                        }).growX().left().padTop(-14.0f).padRight(-14.0f);
                        t.row();
                        if (mod.meta.author != null) {
                            t.add(Core.bundle.format("mod.author", mod.meta.author));
                            t.row();
                        }
                        if (mod.meta.description != null) {
                            t.labelWrap("[lightgray]" + mod.meta.description).growX();
                            t.row();
                        }
                    }).width(500.0f);
                    table.row();
                }
            });
        } else {
            this.cont.table(Styles.black6, t -> t.add("$mods.none")).height(80.0f);
        }
        this.cont.row();
        this.cont.addImageTextButton("$mod.import", Icon.add, () -> Vars.platform.showFileChooser(true, "zip", file -> {
            try {
                Vars.mods.importMod((FileHandle)file);
                this.setup();
            }
            catch (IOException e) {
                Vars.ui.showException(e);
                e.printStackTrace();
            }
        })).margin(12.0f).width(400.0f);
    }
}

