/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.event.ElementGestureListener;
import io.anuke.arc.scene.event.InputEvent;
import io.anuke.arc.scene.event.InputListener;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MinimapDialog
extends FloatingDialog {
    public MinimapDialog() {
        super("$minimap");
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
        this.shouldPause = true;
        this.titleTable.remove();
        this.onResize(this::setup);
    }

    void setup() {
        this.cont.clear();
        this.cont.table(Tex.pane, t -> t.addRect((x, y, width, height) -> {
            if (Vars.renderer.minimap.getRegion() == null) {
                return;
            }
            Draw.color(Color.white);
            Draw.alpha(this.parentAlpha);
            Draw.rect(Vars.renderer.minimap.getRegion(), x + width / 2.0f, y + height / 2.0f, width, height);
            if (Vars.renderer.minimap.getTexture() != null) {
                Vars.renderer.minimap.drawEntities(x, y, width, height);
            }
        }).grow()).size(Math.min((float)Core.graphics.getWidth() / 1.1f, (float)Core.graphics.getHeight() / 1.3f) / Scl.scl(1.0f)).padTop(-20.0f);
        this.cont.addListener(new InputListener(){

            @Override
            public boolean scrolled(InputEvent event, float x, float y, float amountx, float amounty) {
                Vars.renderer.minimap.zoomBy(amounty);
                return true;
            }
        });
        this.cont.addListener(new ElementGestureListener(){
            float lzoom = -1.0f;

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                this.lzoom = Vars.renderer.minimap.getZoom();
            }

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (this.lzoom < 0.0f) {
                    this.lzoom = Vars.renderer.minimap.getZoom();
                }
                Vars.renderer.minimap.setZoom(initialDistance / distance * this.lzoom);
            }
        });
        Core.app.post(() -> Core.scene.setScrollFocus(this.cont));
    }
}

