/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapsDialog
extends FloatingDialog {
    private FloatingDialog dialog;

    public MapsDialog() {
        super("$maps");
        this.buttons.remove();
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                Core.app.post(this::hide);
            }
        });
        this.shown(this::setup);
        this.onResize(() -> {
            if (this.dialog != null) {
                this.dialog.hide();
            }
            this.setup();
        });
    }

    void setup() {
        this.buttons.clearChildren();
        if (Core.graphics.isPortrait()) {
            this.buttons.addImageTextButton("$back", Icon.arrowLeft, this::hide).size(420.0f, 64.0f).colspan(2);
            this.buttons.row();
        } else {
            this.buttons.addImageTextButton("$back", Icon.arrowLeft, this::hide).size(210.0f, 64.0f);
        }
        this.buttons.addImageTextButton("$editor.newmap", Icon.add, () -> Vars.ui.showTextInput("$editor.newmap", "$name", "", text -> {
            Runnable show = () -> Vars.ui.loadAnd(() -> {
                this.hide();
                Vars.ui.editor.show();
                Vars.ui.editor.editor.getTags().put("name", text);
                Events.fire(new EventType.MapMakeEvent());
            });
            if (Vars.maps.byName((String)text) != null) {
                Vars.ui.showErrorMessage("$editor.exists");
            } else {
                show.run();
            }
        })).size(210.0f, 64.0f);
        this.buttons.addImageTextButton("$editor.importmap", Icon.load, () -> Vars.platform.showFileChooser(true, "msav", file -> Vars.ui.loadAnd(() -> Vars.maps.tryCatchMapError(() -> {
            if (MapIO.isImage(file)) {
                Vars.ui.showErrorMessage("$editor.errorimage");
                return;
            }
            Map map = MapIO.createMap(file, true);
            String name = map.tags.getOr("name", () -> {
                String result = "unknown";
                int number = 0;
                while (Vars.maps.byName(result + number++) != null) {
                }
                return result + number;
            });
            if (name == null) {
                Vars.ui.showErrorMessage("$editor.errorname");
                return;
            }
            Map conflict = Vars.maps.all().find((T m) -> m.name().equals(name));
            if (conflict != null && !conflict.custom) {
                Vars.ui.showInfo(Core.bundle.format("editor.import.exists", name));
            } else if (conflict != null) {
                Vars.ui.showConfirm("$confirm", "$editor.overwrite.confirm", () -> Vars.maps.tryCatchMapError(() -> {
                    Vars.maps.removeMap(conflict);
                    Vars.maps.importMap(map.file);
                    this.setup();
                }));
            } else {
                Vars.maps.importMap(map.file);
                this.setup();
            }
        })))).size(210.0f, 64.0f);
        this.cont.clear();
        Table maps = new Table();
        maps.marginRight(24.0f);
        ScrollPane pane = new ScrollPane((Element)maps);
        pane.setFadeScrollBars(false);
        int maxwidth = Mathf.clamp((int)((float)Core.graphics.getWidth() / Scl.scl(230.0f)), 1, 8);
        float mapsize = 200.0f;
        int i = 0;
        for (Map map : Vars.maps.all()) {
            if (i % maxwidth == 0) {
                maps.row();
            }
            TextButton button = maps.addButton("", Styles.cleart, () -> this.showMapInfo(map)).width(mapsize).pad(8.0f).get();
            button.clearChildren();
            button.margin(9.0f);
            button.add(map.name()).width(mapsize - 18.0f).center().get().setEllipsis(true);
            button.row();
            button.addImage().growX().pad(4.0f).color(Pal.gray);
            button.row();
            button.stack(new Image(map.safeTexture()).setScaling(Scaling.fit), new BorderImage(map.safeTexture()).setScaling(Scaling.fit)).size(mapsize - 20.0f);
            button.row();
            button.add(map.custom ? "$custom" : (map.workshop ? "$workshop" : "$builtin")).color(Color.gray).padTop(3.0f);
            ++i;
        }
        if (Vars.maps.all().size == 0) {
            maps.add("$maps.none");
        }
        this.cont.add(this.buttons).growX();
        this.cont.row();
        this.cont.add(pane).uniformX();
    }

    void showMapInfo(Map map) {
        this.dialog = new FloatingDialog("$editor.mapinfo");
        this.dialog.addCloseButton();
        float mapsize = Core.graphics.isPortrait() ? 160.0f : 300.0f;
        Table table = this.dialog.cont;
        table.stack(new Image(map.safeTexture()).setScaling(Scaling.fit), new BorderImage(map.safeTexture()).setScaling(Scaling.fit)).size(mapsize);
        table.table(Styles.black, desc -> {
            desc.top();
            Table t = new Table();
            t.margin(6.0f);
            ScrollPane pane = new ScrollPane((Element)t);
            desc.add(pane).grow();
            t.top();
            t.defaults().padTop(10.0f).left();
            t.add("$editor.name").padRight(10.0f).color(Color.gray).padTop(0.0f);
            t.row();
            t.add(map.name()).growX().wrap().padTop(2.0f);
            t.row();
            t.add("$editor.author").padRight(10.0f).color(Color.gray);
            t.row();
            t.add(map.custom && map.author().isEmpty() ? "Anuke" : map.author()).growX().wrap().padTop(2.0f);
            t.row();
            t.add("$editor.description").padRight(10.0f).color(Color.gray).top();
            t.row();
            t.add(map.description()).growX().wrap().padTop(2.0f);
        }).height(mapsize).width(mapsize);
        table.row();
        table.addImageTextButton("$editor.openin", Icon.loadMapSmall, () -> {
            try {
                Vars.ui.editor.beginEditMap(map.file);
                this.dialog.hide();
                this.hide();
            }
            catch (Exception e) {
                e.printStackTrace();
                Vars.ui.showErrorMessage("$error.mapnotfound");
            }
        }).fillX().height(54.0f).marginLeft(10.0f);
        table.addImageTextButton(map.workshop && Vars.steam ? "$view.workshop" : "$delete", map.workshop && Vars.steam ? Icon.linkSmall : Icon.trash16Small, () -> {
            if (map.workshop && Vars.steam) {
                Vars.platform.viewListing(map);
            } else {
                Vars.ui.showConfirm("$confirm", Core.bundle.format("map.delete", map.name()), () -> {
                    Vars.maps.removeMap(map);
                    this.dialog.hide();
                    this.setup();
                });
            }
        }).fillX().height(54.0f).marginLeft(10.0f).disabled(!map.workshop && !map.custom);
        this.dialog.show();
    }
}

