/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.CustomRulesDialog;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class MapPlayDialog
extends FloatingDialog {
    CustomRulesDialog dialog = new CustomRulesDialog();
    Rules rules;
    @ArcAnnotate.NonNull
    Gamemode selectedGamemode = Gamemode.survival;
    Map lastMap;

    public MapPlayDialog() {
        super("");
        this.setFillParent(false);
        this.onResize(() -> {
            if (this.lastMap != null) {
                Rules rules = this.rules;
                this.show(this.lastMap);
                this.rules = rules;
            }
        });
    }

    public void show(Map map) {
        this.lastMap = map;
        this.title.setText(map.name());
        this.cont.clearChildren();
        if (!this.selectedGamemode.valid(map)) {
            this.selectedGamemode = Structs.find(Gamemode.all, m -> m.valid(map));
            if (this.selectedGamemode == null) {
                this.selectedGamemode = Gamemode.survival;
            }
        }
        this.rules = map.applyRules(this.selectedGamemode);
        Table selmode = new Table();
        selmode.add("$level.mode").colspan(4);
        selmode.row();
        int i = 0;
        Table modes = new Table();
        for (Gamemode mode : Gamemode.values()) {
            if (mode.hidden) continue;
            modes.addButton(mode.toString(), Styles.togglet, () -> {
                this.selectedGamemode = mode;
                this.rules = map.applyRules(mode);
            }).update((T b) -> b.setChecked(this.selectedGamemode == mode)).size(140.0f, 54.0f).disabled(!mode.valid(map));
            if (i++ % 2 != 1) continue;
            modes.row();
        }
        selmode.add(modes);
        selmode.addButton("?", this::displayGameModeHelp).width(50.0f).fillY().padLeft(18.0f);
        this.cont.add(selmode);
        this.cont.row();
        this.cont.addImageTextButton("$customize", Icon.toolsSmall, () -> this.dialog.show(this.rules, () -> {
            this.rules = map.applyRules(this.selectedGamemode);
            return this.rules;
        })).width(230.0f);
        this.cont.row();
        this.cont.add(new BorderImage(map.safeTexture(), 3.0f)).size(Vars.mobile && !Core.graphics.isPortrait() ? 150.0f : 250.0f).get().setScaling(Scaling.fit);
        if (Gamemode.survival.valid(map)) {
            this.cont.row();
            this.cont.label(() -> Core.bundle.format("level.highscore", map.getHightScore())).pad(3.0f);
        }
        this.buttons.clearChildren();
        this.addCloseButton();
        this.buttons.addImageTextButton("$play", Icon.play, () -> {
            Vars.control.playMap(map, this.rules);
            this.hide();
            Vars.ui.custom.hide();
        }).size(210.0f, 64.0f);
        this.show();
    }

    private void displayGameModeHelp() {
        FloatingDialog d = new FloatingDialog(Core.bundle.get("mode.help.title"));
        d.setFillParent(false);
        Table table = new Table();
        table.defaults().pad(1.0f);
        ScrollPane pane = new ScrollPane((Element)table);
        pane.setFadeScrollBars(false);
        table.row();
        for (Gamemode mode : Gamemode.values()) {
            if (mode.hidden) continue;
            table.labelWrap("[accent]" + mode.toString() + ":[] [lightgray]" + mode.description()).width(400.0f);
            table.row();
        }
        d.cont.add(pane);
        d.buttons.addButton("$ok", d::hide).size(110.0f, 50.0f).pad(10.0f);
        d.show();
    }
}

