/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class LoadoutDialog
extends FloatingDialog {
    private Runnable hider;
    private Runnable resetter;
    private Runnable updater;
    private Array<ItemStack> stacks = new Array();
    private Array<ItemStack> originalStacks = new Array();
    private Table items;
    private int capacity;

    public LoadoutDialog() {
        super("$configure");
        this.setFillParent(true);
        this.keyDown(key -> {
            if (key == KeyCode.ESCAPE || key == KeyCode.BACK) {
                Core.app.post(this::hide);
            }
        });
        this.cont.pane((Table t) -> {
            this.items = t.margin(10.0f);
        }).left();
        this.shown(this::setup);
        this.hidden(() -> {
            this.originalStacks.selectFrom(this.stacks, s -> s.amount > 0);
            this.updater.run();
            if (this.hider != null) {
                this.hider.run();
            }
        });
        this.buttons.addImageTextButton("$back", Icon.arrowLeft, this::hide).size(210.0f, 64.0f);
        this.buttons.addImageTextButton("$settings.reset", Icon.refreshSmall, () -> {
            this.resetter.run();
            this.reseed();
            this.updater.run();
            this.setup();
        }).size(210.0f, 64.0f);
    }

    public void show(int capacity, Array<ItemStack> stacks, Runnable reseter, Runnable updater, Runnable hider) {
        this.originalStacks = stacks;
        this.reseed();
        this.resetter = reseter;
        this.updater = updater;
        this.capacity = capacity;
        this.hider = hider;
        this.show();
    }

    void setup() {
        this.items.clearChildren();
        this.items.left();
        float bsize = 40.0f;
        int i = 0;
        for (ItemStack stack : this.stacks) {
            this.items.table(Tex.pane, t -> {
                t.margin(4.0f).marginRight(8.0f).left();
                t.addButton("-", Styles.cleart, () -> {
                    stack.amount = Math.max(stack.amount - this.step(stack.amount), 0);
                    this.updater.run();
                }).size(bsize);
                t.addButton("+", Styles.cleart, () -> {
                    stack.amount = Math.min(stack.amount + this.step(stack.amount), this.capacity);
                    this.updater.run();
                }).size(bsize);
                t.addImageButton((Drawable)Icon.pencilSmaller, Styles.cleari, () -> Vars.ui.showTextInput("$configure", stack.item.localizedName, 10, stack.amount + "", true, str -> {
                    int amount;
                    if (Strings.canParsePostiveInt(str) && (amount = Strings.parseInt(str)) >= 0 && amount <= this.capacity) {
                        stack.amount = amount;
                        this.updater.run();
                        return;
                    }
                    Vars.ui.showInfo(Core.bundle.format("configure.invalid", this.capacity));
                })).size(bsize);
                t.addImage(stack.item.icon(Cicon.small)).size(24.0f).padRight(4.0f).padLeft(4.0f);
                t.label(() -> stack.amount + "").left().width(90.0f);
            }).pad(2.0f).left().fillX();
            if (++i % 2 != 0 && (!Vars.mobile || !Core.graphics.isPortrait())) continue;
            this.items.row();
        }
    }

    private void reseed() {
        this.stacks = this.originalStacks.map(ItemStack::copy);
        this.stacks.addAll(Vars.content.items().select(i -> i.type == ItemType.material && !this.stacks.contains((ItemStack)((Object)((Predicate<ItemStack>)stack -> stack.item == i)))).map(i -> new ItemStack((Item)i, 0)));
        this.stacks.sort(Structs.comparingInt(s -> s.item.id));
    }

    private int step(int amount) {
        if (amount < 1000) {
            return 100;
        }
        if (amount < 2000) {
            return 200;
        }
        if (amount < 5000) {
            return 500;
        }
        return 1000;
    }
}

