/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.Saves;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import java.io.IOException;

public class LoadDialog
extends FloatingDialog {
    ScrollPane pane;
    Table slots;

    public LoadDialog() {
        this("$loadgame");
    }

    public LoadDialog(String title) {
        super(title);
        this.setup();
        this.shown(() -> {
            this.setup();
            Time.runTask(2.0f, () -> Core.scene.setScrollFocus(this.pane));
        });
        this.addCloseButton();
    }

    protected void setup() {
        this.cont.clear();
        this.slots = new Table();
        this.pane = new ScrollPane((Element)this.slots);
        this.pane.setFadeScrollBars(false);
        this.pane.setScrollingDisabled(true, false);
        this.slots.marginRight(24.0f);
        Time.runTask(2.0f, () -> Core.scene.setScrollFocus(this.pane));
        Array<Saves.SaveSlot> array = Vars.control.saves.getSaveSlots();
        array.sort((slot, other) -> -Long.compare(slot.getTimestamp(), other.getTimestamp()));
        for (Saves.SaveSlot slot2 : array) {
            if (slot2.isHidden()) continue;
            TextButton button = new TextButton("", Styles.cleart);
            button.getLabel().remove();
            button.clearChildren();
            button.defaults().left();
            button.table((Table title) -> {
                title.add("[accent]" + slot2.getName()).left().growX().width(230.0f).wrap();
                title.table((Table t) -> {
                    t.right();
                    t.addImageButton((Drawable)Icon.floppy, Styles.emptytogglei, () -> slot2.setAutosave(!slot2.isAutosave())).checked(slot2.isAutosave()).right();
                    t.addImageButton((Drawable)Icon.trash, Styles.emptyi, () -> Vars.ui.showConfirm("$confirm", "$save.delete.confirm", () -> {
                        slot2.delete();
                        this.setup();
                    })).right();
                    t.addImageButton((Drawable)Icon.pencil, Styles.emptyi, () -> Vars.ui.showTextInput("$save.rename", "$save.rename.text", slot2.getName(), text -> {
                        slot2.setName((String)text);
                        this.setup();
                    })).right();
                    t.addImageButton((Drawable)Icon.save, Styles.emptyi, () -> {
                        if (!Vars.ios) {
                            Vars.platform.showFileChooser(false, "msav", file -> {
                                try {
                                    slot2.exportFile((FileHandle)file);
                                    this.setup();
                                }
                                catch (IOException e) {
                                    Vars.ui.showException("save.export.fail", e);
                                }
                            });
                        } else {
                            try {
                                FileHandle file2 = Core.files.local("save-" + slot2.getName() + "." + "msav");
                                slot2.exportFile(file2);
                                Vars.platform.shareFile(file2);
                            }
                            catch (Exception e) {
                                Vars.ui.showException("save.export.fail", e);
                            }
                        }
                    }).right();
                }).padRight(-10.0f).growX();
            }).growX().colspan(2);
            button.row();
            String color = "[lightgray]";
            TextureAtlas.AtlasRegion def = Core.atlas.find("nomap");
            button.left().add(new BorderImage(def, 4.0f)).update((T i) -> {
                TextureRegionDrawable draw = (TextureRegionDrawable)i.getDrawable();
                if (draw.getRegion().getTexture().isDisposed()) {
                    draw.setRegion(def);
                }
                Texture text = slot2.previewTexture();
                if (draw.getRegion() == def && text != null) {
                    draw.setRegion(new TextureRegion(text));
                }
                i.setScaling(Scaling.fit);
            }).left().size(160.0f).padRight(6.0f);
            button.table((Table meta) -> {
                meta.left().top();
                meta.defaults().padBottom(-2.0f).left().width(290.0f);
                meta.row();
                meta.labelWrap(Core.bundle.format("save.map", color + (slot2.getMap() == null ? Core.bundle.get("unknown") : slot2.getMap().name())));
                meta.row();
                meta.labelWrap(slot2.mode().toString() + " /" + color + " " + Core.bundle.format("save.wave", color + slot2.getWave()));
                meta.row();
                meta.labelWrap(() -> Core.bundle.format("save.autosave", color + Core.bundle.get(slot2.isAutosave() ? "on" : "off")));
                meta.row();
                meta.labelWrap(() -> Core.bundle.format("save.playtime", color + slot2.getPlayTime()));
                meta.row();
                meta.labelWrap(color + slot2.getDate());
                meta.row();
            }).left().growX().width(250.0f);
            this.modifyButton(button, slot2);
            this.slots.add(button).uniformX().fillX().pad(4.0f).padRight(-4.0f).margin(10.0f).row();
        }
        this.cont.add(this.pane);
        this.addSetup();
    }

    public void addSetup() {
        boolean valids = false;
        for (Saves.SaveSlot slot : Vars.control.saves.getSaveSlots()) {
            if (slot.isHidden()) continue;
            valids = true;
        }
        if (!valids) {
            this.slots.row();
            this.slots.addButton("$save.none", () -> {}).disabled(true).fillX().margin(20.0f).minWidth(340.0f).height(80.0f).pad(4.0f);
        }
        this.slots.row();
        this.slots.addImageTextButton("$save.import", Icon.add, () -> Vars.platform.showFileChooser(true, "msav", file -> {
            if (SaveIO.isSaveValid(file)) {
                try {
                    Vars.control.saves.importSave((FileHandle)file);
                    this.setup();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Vars.ui.showException("$save.import.fail", e);
                }
            } else {
                Vars.ui.showErrorMessage("$save.import.invalid");
            }
        })).fillX().margin(10.0f).minWidth(300.0f).height(70.0f).pad(4.0f).padRight(-4.0f);
    }

    public void runLoadSave(Saves.SaveSlot slot) {
        slot.cautiousLoad(() -> Vars.ui.loadAnd(() -> {
            this.hide();
            Vars.ui.paused.hide();
            try {
                Vars.net.reset();
                slot.load();
                Vars.state.rules.editor = false;
                Vars.state.rules.zone = null;
                Vars.state.set(GameState.State.playing);
            }
            catch (SaveIO.SaveException e) {
                Log.err(e);
                Vars.state.set(GameState.State.menu);
                Vars.logic.reset();
                Vars.ui.showErrorMessage("$save.corrupted");
            }
        }));
    }

    public void modifyButton(TextButton button, Saves.SaveSlot slot) {
        button.clicked(() -> {
            if (!button.childrenPressed()) {
                this.runLoadSave(slot);
            }
        });
    }
}

