/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.event.Touchable;
import io.anuke.arc.scene.ui.ButtonGroup;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.Label;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.TextButton;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.OS;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import java.util.Arrays;

public class FileChooser
extends FloatingDialog {
    private static final FileHandle homeDirectory;
    private static FileHandle lastDirectory;
    private Table files;
    private FileHandle directory = lastDirectory;
    private ScrollPane pane;
    private TextField navigation;
    private TextField filefield;
    private TextButton ok;
    private FileHistory stack = new FileHistory();
    private Predicate<FileHandle> filter;
    private Consumer<FileHandle> selectListener;
    private boolean open;

    public FileChooser(String title, Predicate<FileHandle> filter, boolean open, Consumer<FileHandle> result) {
        super(title);
        this.setFillParent(true);
        this.open = open;
        this.filter = filter;
        this.selectListener = result;
        this.onResize(() -> {
            this.cont.clear();
            this.setupWidgets();
        });
        this.shown(() -> {
            this.cont.clear();
            this.setupWidgets();
        });
    }

    private void setupWidgets() {
        this.cont.margin(-10.0f);
        Table content = new Table();
        this.filefield = new TextField();
        this.filefield.setOnlyFontChars(false);
        if (!this.open) {
            Vars.platform.addDialog(this.filefield);
        }
        this.filefield.setDisabled(this.open);
        this.ok = new TextButton(this.open ? "$load" : "$save");
        this.ok.clicked(() -> {
            if (this.ok.isDisabled()) {
                return;
            }
            if (this.selectListener != null) {
                this.selectListener.accept(this.directory.child(this.filefield.getText()));
            }
            this.hide();
        });
        this.filefield.changed(() -> this.ok.setDisabled(this.filefield.getText().replace(" ", "").isEmpty()));
        this.filefield.change();
        TextButton cancel = new TextButton("$cancel");
        cancel.clicked(this::hide);
        this.navigation = new TextField("");
        this.navigation.touchable(Touchable.disabled);
        this.files = new Table();
        this.files.marginRight(10.0f);
        this.files.marginLeft(3.0f);
        this.pane = new ScrollPane((Element)this.files);
        this.pane.setOverscroll(false, false);
        this.pane.setFadeScrollBars(false);
        this.updateFiles(true);
        Table icontable = new Table();
        ImageButton up = new ImageButton(Icon.folderParent);
        up.clicked(() -> {
            this.directory = this.directory.parent();
            this.updateFiles(true);
        });
        if (OS.isMac) {
            up.setDisabled(true);
        }
        ImageButton back = new ImageButton(Icon.arrowLeft);
        ImageButton forward = new ImageButton(Icon.arrowRight);
        forward.clicked(() -> this.stack.forward());
        back.clicked(() -> this.stack.back());
        forward.setDisabled(() -> !this.stack.canForward());
        back.setDisabled(() -> !this.stack.canBack());
        ImageButton home = new ImageButton(Icon.home);
        home.clicked(() -> {
            lastDirectory = this.directory = homeDirectory;
            this.updateFiles(true);
        });
        icontable.defaults().height(60.0f).growX().padTop(5.0f).uniform();
        icontable.add(home);
        icontable.add(back);
        icontable.add(forward);
        icontable.add(up);
        Table fieldcontent = new Table();
        fieldcontent.bottom().left().add(new Label("$filename"));
        fieldcontent.add(this.filefield).height(40.0f).fillX().expandX().padLeft(10.0f);
        Table buttons = new Table();
        buttons.defaults().growX().height(60.0f);
        buttons.add(cancel);
        buttons.add(this.ok);
        content.top().left();
        content.add(icontable).expandX().fillX();
        content.row();
        content.center().add(this.pane).colspan(3).grow();
        content.row();
        if (!this.open) {
            content.bottom().left().add(fieldcontent).colspan(3).grow().padTop(-2.0f).padBottom(2.0f);
            content.row();
        }
        content.add(buttons).growX();
        this.cont.add(content).grow();
    }

    private void updateFileFieldStatus() {
        if (!this.open) {
            this.ok.setDisabled(this.filefield.getText().replace(" ", "").isEmpty());
        } else {
            this.ok.setDisabled(!this.directory.child(this.filefield.getText()).exists() || this.directory.child(this.filefield.getText()).isDirectory());
        }
    }

    private FileHandle[] getFileNames() {
        FileHandle[] handles = this.directory.list(file -> !file.getName().startsWith("."));
        Arrays.sort(handles, (a, b) -> {
            if (a.isDirectory() && !b.isDirectory()) {
                return -1;
            }
            if (!a.isDirectory() && b.isDirectory()) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a.name(), b.name());
        });
        return handles;
    }

    private void updateFiles(boolean push) {
        if (push) {
            this.stack.push(this.directory);
        }
        this.navigation.setText(OS.isMac ? this.directory.name() : this.directory.toString());
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        layout.setText(Fonts.def, this.navigation.getText());
        if (layout.width < this.navigation.getWidth()) {
            this.navigation.setCursorPosition(0);
        } else {
            this.navigation.setCursorPosition(this.navigation.getText().length());
        }
        Pools.free(layout);
        this.files.clearChildren();
        this.files.top().left();
        FileHandle[] names = this.getFileNames();
        if (!OS.isMac) {
            Image upimage = new Image(Icon.folderParentSmall);
            TextButton upbutton = new TextButton(".." + this.directory.toString(), Styles.clearTogglet);
            upbutton.clicked(() -> {
                lastDirectory = this.directory = this.directory.parent();
                this.updateFiles(true);
            });
            upbutton.left().add(upimage).padRight(4.0f).padLeft(4.0f);
            upbutton.getLabel().setAlignment(8);
            upbutton.getCells().reverse();
            this.files.add(upbutton).align(10).fillX().expandX().height(50.0f).pad(2.0f).colspan(2);
            this.files.row();
        }
        ButtonGroup<TextButton> group = new ButtonGroup<TextButton>();
        group.setMinCheckCount(0);
        for (FileHandle file : names) {
            if (!file.isDirectory() && !this.filter.test(file)) continue;
            String filename = file.name();
            TextButton button = new TextButton(filename, Styles.clearTogglet);
            button.getLabel().setWrap(false);
            button.getLabel().setEllipsis(true);
            group.add(button);
            button.clicked(() -> {
                if (!file.isDirectory()) {
                    this.filefield.setText(filename);
                    this.updateFileFieldStatus();
                } else {
                    lastDirectory = this.directory = this.directory.child(filename);
                    this.updateFiles(true);
                }
            });
            this.filefield.changed(() -> button.setChecked(filename.equals(this.filefield.getText())));
            Image image = new Image(file.isDirectory() ? Icon.folderSmall : Icon.fileTextSmall);
            button.add(image).padRight(4.0f).padLeft(4.0f);
            button.getCells().reverse();
            this.files.top().left().add(button).align(10).fillX().expandX().height(50.0f).pad(2.0f).padTop(0.0f).padBottom(0.0f).colspan(2);
            button.getLabel().setAlignment(8);
            this.files.row();
        }
        this.pane.setScrollY(0.0f);
        this.updateFileFieldStatus();
        if (this.open) {
            this.filefield.clearText();
        }
    }

    private String shorten(String string) {
        int max = 30;
        if (string.length() <= max) {
            return string;
        }
        return string.substring(0, max - 3).concat("...");
    }

    static {
        lastDirectory = homeDirectory = Core.files.absolute(OS.isMac ? OS.getProperty("user.home") + "/Downloads/" : Core.files.getExternalStoragePath());
    }

    public class FileHistory {
        private Array<FileHandle> history = new Array();
        private int index;

        public void push(FileHandle file) {
            if (this.index != this.history.size) {
                this.history.truncate(this.index);
            }
            this.history.add(file);
            ++this.index;
        }

        public void back() {
            if (!this.canBack()) {
                return;
            }
            --this.index;
            FileChooser.this.directory = this.history.get(this.index - 1);
            lastDirectory = FileChooser.this.directory;
            FileChooser.this.updateFiles(false);
        }

        public void forward() {
            if (!this.canForward()) {
                return;
            }
            FileChooser.this.directory = this.history.get(this.index);
            lastDirectory = FileChooser.this.directory;
            ++this.index;
            FileChooser.this.updateFiles(false);
        }

        public boolean canForward() {
            return this.index < this.history.size;
        }

        public boolean canBack() {
            return this.index != 1 && this.index > 0;
        }

        void print() {
            System.out.println("\n\n\n\n\n\n");
            int i = 0;
            for (FileHandle file : this.history) {
                if (this.index == ++i) {
                    System.out.println("[[" + file.toString() + "]]");
                    continue;
                }
                System.out.println("--" + file.toString() + "--");
            }
        }
    }
}

