/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.BooleanConsumer;
import io.anuke.arc.function.BooleanProvider;
import io.anuke.arc.function.FloatConsumer;
import io.anuke.arc.function.FloatProvider;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.LoadoutDialog;
import io.anuke.mindustry.world.Block;

public class CustomRulesDialog
extends FloatingDialog {
    private Table main;
    private Rules rules;
    private Supplier<Rules> resetter;
    private LoadoutDialog loadoutDialog = new LoadoutDialog();
    private FloatingDialog banDialog = new FloatingDialog("$bannedblocks");

    public CustomRulesDialog() {
        super("$mode.custom");
        this.banDialog.addCloseButton();
        this.banDialog.shown(this::rebuildBanned);
        this.banDialog.buttons.addImageTextButton("$addall", Icon.arrow16Small, () -> {
            this.rules.bannedBlocks.addAll(Vars.content.blocks().select(Block::isBuildable));
            this.rebuildBanned();
        }).size(180.0f, 64.0f);
        this.banDialog.buttons.addImageTextButton("$clear", Icon.trash16Small, () -> {
            this.rules.bannedBlocks.clear();
            this.rebuildBanned();
        }).size(180.0f, 64.0f);
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
    }

    private void rebuildBanned() {
        float previousScroll = this.banDialog.cont.getChildren().isEmpty() ? 0.0f : ((ScrollPane)this.banDialog.cont.getChildren().first()).getScrollY();
        this.banDialog.cont.clear();
        this.banDialog.cont.pane((Table t) -> {
            t.margin(10.0f);
            if (this.rules.bannedBlocks.isEmpty()) {
                t.add("$empty");
            }
            Array<Block> array = Array.with(this.rules.bannedBlocks);
            array.sort();
            int cols = Vars.mobile && Core.graphics.isPortrait() ? 1 : (Vars.mobile ? 2 : 3);
            int i = 0;
            for (Block block : array) {
                t.table(Tex.underline, b -> {
                    b.left().margin(4.0f);
                    b.addImage(block.icon(Cicon.medium)).size(Cicon.medium.size).padRight(3.0f);
                    b.add(block.localizedName).color(Color.lightGray).padLeft(3.0f).growX().left().wrap();
                    b.addImageButton((Drawable)Icon.cancelSmall, Styles.clearPartiali, () -> {
                        this.rules.bannedBlocks.remove(block);
                        this.rebuildBanned();
                    }).size(70.0f).pad(-4.0f).padLeft(0.0f);
                }).size(300.0f, 70.0f).padRight(5.0f);
                if (++i % cols != 0) continue;
                t.row();
            }
        }).get().setScrollYForce(previousScroll);
        this.banDialog.cont.row();
        this.banDialog.cont.addImageTextButton("$add", Icon.addSmall, () -> {
            FloatingDialog dialog = new FloatingDialog("$add");
            dialog.cont.pane((Table t) -> {
                t.left().margin(14.0f);
                int[] i = new int[]{0};
                Vars.content.blocks().each(b -> !this.rules.bannedBlocks.contains((Block)b) && b.isBuildable(), b -> {
                    int cols = Vars.mobile && Core.graphics.isPortrait() ? 4 : 12;
                    t.addImageButton((Drawable)new TextureRegionDrawable(b.icon(Cicon.medium)), Styles.cleari, () -> {
                        this.rules.bannedBlocks.add((Block)b);
                        this.rebuildBanned();
                        dialog.hide();
                    }).size(60.0f).get().resizeImage(Cicon.medium.size);
                    i[0] = i[0] + 1;
                    if (i[0] % cols == 0) {
                        t.row();
                    }
                });
            });
            dialog.addCloseButton();
            dialog.show();
        }).size(300.0f, 64.0f);
    }

    public void show(Rules rules, Supplier<Rules> resetter) {
        this.rules = rules;
        this.resetter = resetter;
        this.show();
    }

    void setup() {
        this.cont.clear();
        this.cont.pane((Table m) -> {
            this.main = m;
        });
        this.main.margin(10.0f);
        this.main.addButton("$settings.reset", () -> {
            this.rules = this.resetter.get();
            this.setup();
            this.requestKeyboard();
            this.requestScroll();
        }).size(300.0f, 50.0f);
        this.main.left().defaults().fillX().left().pad(5.0f);
        this.main.row();
        this.title("$rules.title.waves");
        this.check("$rules.waves", b -> {
            this.rules.waves = b;
        }, () -> this.rules.waves);
        this.check("$rules.wavetimer", b -> {
            this.rules.waveTimer = b;
        }, () -> this.rules.waveTimer);
        this.check("$rules.waitForWaveToEnd", b -> {
            this.rules.waitForWaveToEnd = b;
        }, () -> this.rules.waitForWaveToEnd);
        this.number("$rules.wavespacing", false, f -> {
            this.rules.waveSpacing = f * 60.0f;
        }, () -> this.rules.waveSpacing / 60.0f, () -> true);
        this.number("$rules.dropzoneradius", false, f -> {
            this.rules.dropZoneRadius = f * 8.0f;
        }, () -> this.rules.dropZoneRadius / 8.0f, () -> true);
        this.title("$rules.title.respawns");
        this.number("$rules.respawntime", f -> {
            this.rules.respawnTime = f * 60.0f;
        }, () -> this.rules.respawnTime / 60.0f);
        this.title("$rules.title.resourcesbuilding");
        this.check("$rules.infiniteresources", b -> {
            this.rules.infiniteResources = b;
        }, () -> this.rules.infiniteResources);
        this.number("$rules.buildcostmultiplier", false, f -> {
            this.rules.buildCostMultiplier = f;
        }, () -> this.rules.buildCostMultiplier, () -> !this.rules.infiniteResources);
        this.number("$rules.buildspeedmultiplier", f -> {
            this.rules.buildSpeedMultiplier = f;
        }, () -> this.rules.buildSpeedMultiplier);
        this.main.addButton("$configure", () -> this.loadoutDialog.show(Blocks.coreShard.itemCapacity, this.rules.loadout, () -> {
            this.rules.loadout.clear();
            this.rules.loadout.add(new ItemStack(Items.copper, 100));
        }, () -> {}, () -> {})).left().width(300.0f);
        this.main.row();
        this.main.addButton("$bannedblocks", this.banDialog::show).left().width(300.0f);
        this.main.row();
        this.title("$rules.title.player");
        this.number("$rules.playerhealthmultiplier", f -> {
            this.rules.playerHealthMultiplier = f;
        }, () -> this.rules.playerHealthMultiplier);
        this.number("$rules.playerdamagemultiplier", f -> {
            this.rules.playerDamageMultiplier = f;
        }, () -> this.rules.playerDamageMultiplier);
        this.title("$rules.title.unit");
        this.check("$rules.unitdrops", b -> {
            this.rules.unitDrops = b;
        }, () -> this.rules.unitDrops, () -> true);
        this.number("$rules.unithealthmultiplier", f -> {
            this.rules.unitHealthMultiplier = f;
        }, () -> this.rules.unitHealthMultiplier);
        this.number("$rules.unitdamagemultiplier", f -> {
            this.rules.unitDamageMultiplier = f;
        }, () -> this.rules.unitDamageMultiplier);
        this.number("$rules.unitbuildspeedmultiplier", f -> {
            this.rules.unitBuildSpeedMultiplier = f;
        }, () -> this.rules.unitBuildSpeedMultiplier);
        this.title("$rules.title.enemy");
        this.check("$rules.attack", b -> {
            this.rules.attackMode = b;
        }, () -> this.rules.attackMode);
        this.check("$rules.enemyCheat", b -> {
            this.rules.enemyCheat = b;
        }, () -> this.rules.enemyCheat);
        this.number("$rules.enemycorebuildradius", f -> {
            this.rules.enemyCoreBuildRadius = f * 8.0f;
        }, () -> Math.min(this.rules.enemyCoreBuildRadius / 8.0f, 200.0f));
    }

    void number(String text, FloatConsumer cons, FloatProvider prov) {
        this.number(text, false, cons, prov, () -> true);
    }

    void number(String text, boolean integer, FloatConsumer cons, FloatProvider prov, BooleanProvider condition) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            Vars.platform.addDialog(t.addField((integer ? (float)((int)prov.get()) : prov.get()) + "", s -> cons.accept(Strings.parseFloat(s))).padRight(100.0f).update((T a) -> a.setDisabled(!condition.get())).valid(Strings::canParsePositiveFloat).width(120.0f).left().get());
        }).padTop(0.0f);
        this.main.row();
    }

    void check(String text, BooleanConsumer cons, BooleanProvider prov) {
        this.check(text, cons, prov, () -> true);
    }

    void check(String text, BooleanConsumer cons, BooleanProvider prov, BooleanProvider condition) {
        this.main.addCheck(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).get().left();
        this.main.row();
    }

    void title(String text) {
        this.main.add(text).color(Pal.accent).padTop(20.0f).padBottom(20.0f).padRight(100.0f);
        this.main.row();
    }
}

