/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.ImageButton;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Scaling;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.ui.BorderImage;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.ui.dialogs.MapPlayDialog;

public class CustomGameDialog
extends FloatingDialog {
    private MapPlayDialog dialog = new MapPlayDialog();

    public CustomGameDialog() {
        super("$customgame");
        this.addCloseButton();
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        this.clearChildren();
        this.add(this.titleTable);
        this.row();
        this.stack(this.cont, this.buttons).grow();
        this.buttons.bottom();
        this.cont.clear();
        Table maps = new Table();
        maps.marginRight(14.0f);
        maps.marginBottom(55.0f);
        ScrollPane pane = new ScrollPane((Element)maps);
        pane.setFadeScrollBars(false);
        int maxwidth = Mathf.clamp((int)((float)Core.graphics.getWidth() / Scl.scl(200.0f)), 1, 8);
        float images = 146.0f;
        int i = 0;
        maps.defaults().width(170.0f).fillY().top().pad(4.0f);
        for (Map map : Vars.maps.all()) {
            if (i % maxwidth == 0) {
                maps.row();
            }
            ImageButton image = new ImageButton(new TextureRegion(map.safeTexture()), Styles.cleari);
            image.margin(5.0f);
            image.top();
            Image img = image.getImage();
            img.remove();
            image.row();
            image.table((Table t) -> {
                t.left();
                for (Gamemode mode : Gamemode.all) {
                    if (!mode.valid(map) || !Core.atlas.has("icon-mode-" + mode.name())) continue;
                    t.addImage(Core.atlas.drawable("icon-mode-" + mode.name())).size(16.0f).pad(4.0f);
                }
            }).left();
            image.row();
            image.add(map.name()).pad(1.0f).growX().wrap().left().get().setEllipsis(true);
            image.row();
            image.addImage(Tex.whiteui, Pal.gray).growX().pad(3.0f).height(4.0f);
            image.row();
            image.add(img).size(images);
            BorderImage border = new BorderImage(map.safeTexture(), 3.0f);
            border.setScaling(Scaling.fit);
            image.replaceImage(border);
            image.clicked(() -> this.dialog.show(map));
            maps.add(image);
            ++i;
        }
        if (Vars.maps.all().size == 0) {
            maps.add("$maps.none").pad(50.0f);
        }
        this.cont.add(pane).uniformX();
    }
}

