/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui.dialogs;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.ui.ScrollPane;
import io.anuke.arc.scene.ui.layout.Cell;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.OS;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.ui.Links;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;

public class AboutDialog
extends FloatingDialog {
    private Array<String> contributors = new Array();
    private static ObjectSet<String> bannedItems = ObjectSet.with("google-play", "itch.io", "dev-builds");

    public AboutDialog() {
        super("$about.button");
        this.shown(() -> {
            this.contributors = Array.with(Core.files.internal("contributors").readString("UTF-8").split("\n"));
            Core.app.post(this::setup);
        });
        this.shown(this::setup);
        this.onResize(this::setup);
    }

    void setup() {
        this.cont.clear();
        this.buttons.clear();
        float h = Core.graphics.isPortrait() ? 90.0f : 80.0f;
        float w = Core.graphics.isPortrait() ? 330.0f : 600.0f;
        Table in = new Table();
        ScrollPane pane = new ScrollPane((Element)in);
        for (Links.LinkEntry link : Links.getLinks()) {
            if ((Vars.ios || OS.isMac || Vars.steam) && bannedItems.contains(link.name)) continue;
            Table table = new Table(Tex.underline);
            table.margin(0.0f);
            table.table((Table img) -> {
                img.addImage().height(h - 5.0f).width(40.0f).color(link.color);
                img.row();
                img.addImage().height(5.0f).width(40.0f).color(link.color.cpy().mul(0.8f, 0.8f, 0.8f, 1.0f));
            }).expandY();
            table.table((Table i) -> {
                i.background(Tex.buttonEdge3);
                i.addImage(Core.atlas.drawable("icon-" + link.name));
            }).size(h - 5.0f, h);
            table.table((Table inset) -> {
                inset.add("[accent]" + link.title).growX().left();
                inset.row();
                inset.labelWrap(link.description).width(w - 100.0f).color(Color.lightGray).growX();
            }).padLeft(8.0f);
            table.addImageButton(Icon.link, () -> {
                if (link.name.equals("wiki")) {
                    Events.fire(EventType.Trigger.openWiki);
                }
                if (!Core.net.openURI(link.link)) {
                    Vars.ui.showErrorMessage("$linkfail");
                    Core.app.setClipboardText(link.link);
                }
            }).size(h - 5.0f, h);
            in.add(table).size(w, h).padTop(5.0f).row();
        }
        this.shown(() -> Time.run(1.0f, () -> Core.scene.setScrollFocus(pane)));
        this.cont.add(pane).growX();
        this.addCloseButton();
        this.buttons.addButton("$credits", this::showCredits).size(200.0f, 64.0f);
        if (Core.graphics.isPortrait()) {
            for (Cell cell : this.buttons.getCells()) {
                cell.width(140.0f);
            }
        }
    }

    public void showCredits() {
        FloatingDialog dialog = new FloatingDialog("$credits");
        dialog.addCloseButton();
        dialog.cont.add("$credits.text");
        dialog.cont.row();
        if (!this.contributors.isEmpty()) {
            dialog.cont.addImage().color(Pal.accent).fillX().height(3.0f).pad(3.0f);
            dialog.cont.row();
            dialog.cont.add("$contributors");
            dialog.cont.row();
            dialog.cont.pane(new Table(){
                {
                    int i = 0;
                    this.left();
                    for (String c : AboutDialog.this.contributors) {
                        this.add("[lightgray]" + c).left().pad(3.0f).padLeft(6.0f).padRight(6.0f);
                        if (++i % 3 != 0) continue;
                        this.row();
                    }
                }
            });
        }
        dialog.show();
    }
}

