/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.layout.Stack;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.ui.Cicon;
import io.anuke.mindustry.world.meta.StatUnit;

public class LiquidDisplay
extends Table {
    public final Liquid liquid;
    public final float amount;
    public final boolean perSecond;

    public LiquidDisplay(final Liquid liquid, final float amount, boolean perSecond) {
        this.liquid = liquid;
        this.amount = amount;
        this.perSecond = perSecond;
        this.add(new Stack(){
            {
                this.add(new Image(liquid.icon(Cicon.medium)));
                if (amount != 0.0f) {
                    Table t = new Table().left().bottom();
                    t.add(Strings.autoFixed(amount, 1));
                    this.add(t);
                }
            }
        }).size(32.0f).padRight(3 + (amount != 0.0f && Strings.autoFixed(amount, 1).length() > 2 ? 8 : 0));
        if (perSecond) {
            this.add(StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray);
        }
        this.add(liquid.localizedName());
    }
}

