/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.ui.Cicon;

public class ItemsDisplay
extends Table {
    private StringBuilder builder = new StringBuilder();

    public ItemsDisplay() {
        this.rebuild();
    }

    public void rebuild() {
        this.clear();
        this.top().left();
        this.margin(0.0f);
        this.table(Tex.button, t -> {
            t.margin(10.0f).marginLeft(15.0f).marginTop(15.0f);
            t.label(() -> Vars.state.is(GameState.State.menu) ? "$launcheditems" : "$launchinfo").colspan(3).padBottom(4.0f).left().colspan(3).width(210.0f).wrap();
            t.row();
            for (Item item : Vars.content.items()) {
                if (item.type != ItemType.material || !Vars.data.isUnlocked(item)) continue;
                t.label(() -> this.format(item)).left();
                t.addImage(item.icon(Cicon.small)).size(24.0f).padLeft(4.0f).padRight(4.0f);
                t.add(item.localizedName()).color(Color.lightGray).left();
                t.row();
            }
        });
    }

    private String format(Item item) {
        this.builder.setLength(0);
        this.builder.append(Vars.ui.formatAmount(Vars.data.items().get(item, 0)));
        if (!Vars.state.is(GameState.State.menu) && !Vars.state.teams.get((Team)Vars.player.getTeam()).cores.isEmpty() && Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity != null && Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity.items.get(item) > 0) {
            this.builder.append(" [unlaunched]+ ");
            this.builder.append(Vars.ui.formatAmount(Vars.state.teams.get((Team)Vars.player.getTeam()).cores.first().entity.items.get(item)));
        }
        return this.builder.toString();
    }
}

