/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.Core;
import io.anuke.arc.function.FloatProvider;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.graphics.g2d.ScissorStack;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.scene.Element;
import io.anuke.arc.scene.style.NinePatchDrawable;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.gen.Tex;
import io.anuke.mindustry.ui.Fonts;

public class Bar
extends Element {
    private static Rectangle scissor = new Rectangle();
    private FloatProvider fraction;
    private String name = "";
    private float value;
    private float lastValue;
    private float blink;
    private Color blinkColor = new Color();

    public Bar(String name, Color color, FloatProvider fraction) {
        this.fraction = fraction;
        this.name = Core.bundle.get(name);
        this.blinkColor.set(color);
        this.lastValue = this.value = fraction.get();
        this.setColor(color);
    }

    public Bar(Supplier<String> name, Supplier<Color> color, FloatProvider fraction) {
        this.fraction = fraction;
        this.lastValue = this.value = Mathf.clamp(fraction.get());
        this.update(() -> {
            this.name = (String)name.get();
            this.blinkColor.set((Color)color.get());
            this.setColor((Color)color.get());
        });
    }

    public Bar() {
    }

    public void reset(float value) {
        this.lastValue = this.blink = value;
        this.value = this.blink;
    }

    public void set(Supplier<String> name, FloatProvider fraction, Color color) {
        this.fraction = fraction;
        this.lastValue = fraction.get();
        this.blinkColor.set(color);
        this.setColor(color);
        this.update(() -> {
            this.name = (String)name.get();
        });
    }

    public Bar blink(Color color) {
        this.blinkColor.set(color);
        return this;
    }

    @Override
    public void draw() {
        if (this.fraction == null) {
            return;
        }
        float computed = Mathf.clamp(this.fraction.get());
        if (!Mathf.isEqual(this.lastValue, computed)) {
            this.blink = 1.0f;
            this.lastValue = computed;
        }
        this.blink = Mathf.lerpDelta(this.blink, 0.0f, 0.2f);
        this.value = Mathf.lerpDelta(this.value, computed, 0.15f);
        NinePatchDrawable bar = Tex.bar;
        Draw.colorl(0.1f);
        bar.draw(this.x, this.y, this.width, this.height);
        Draw.color(this.color, this.blinkColor, this.blink);
        NinePatchDrawable top = Tex.barTop;
        float topWidth = this.width * this.value;
        if (topWidth > (float)Core.atlas.find("bar-top").getWidth()) {
            top.draw(this.x, this.y, topWidth, this.height);
        } else if (ScissorStack.pushScissors(scissor.set(this.x, this.y, topWidth, this.height))) {
            top.draw(this.x, this.y, Core.atlas.find("bar-top").getWidth(), this.height);
            ScissorStack.popScissors();
        }
        Draw.color();
        BitmapFont font = Fonts.outline;
        GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        lay.setText(font, this.name);
        font.setColor(Color.white);
        font.draw(this.name, this.x + this.width / 2.0f - lay.width / 2.0f, this.y + this.height / 2.0f + lay.height / 2.0f + 1.0f);
        Pools.free(lay);
    }
}

