/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Loadouts;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Objective;
import io.anuke.mindustry.game.Objectives;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.maps.generators.Generator;
import io.anuke.mindustry.maps.generators.MapGenerator;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Loadout;

public class Zone
extends UnlockableContent {
    @ArcAnnotate.NonNull
    public Generator generator;
    @ArcAnnotate.NonNull
    public Objective configureObjective = new Objectives.ZoneWave(this, 15);
    public Array<Objective> requirements = new Array();
    public Array<Item> resources = new Array();
    public Consumer<Rules> rules = rules -> {};
    public boolean alwaysUnlocked;
    public int conditionWave = Integer.MAX_VALUE;
    public int launchPeriod = 10;
    public Loadout loadout = Loadouts.basicShard;
    public TextureRegion preview;
    protected Array<ItemStack> baseLaunchCost = new Array();
    protected Array<ItemStack> startingItems = new Array();
    protected Array<ItemStack> launchCost;
    private Array<ItemStack> defaultStartingItems = new Array();

    public Zone(String name, Generator generator) {
        super(name);
        this.generator = generator;
    }

    public Zone(String name) {
        this(name, new MapGenerator(name));
    }

    @Override
    public void load() {
        this.preview = Core.atlas.find("zone-" + this.name, Core.atlas.find(this.name + "-zone"));
    }

    public Rules getRules() {
        if (this.generator instanceof MapGenerator) {
            return ((MapGenerator)this.generator).getMap().rules();
        }
        Rules rules = new Rules();
        this.rules.accept(rules);
        return rules;
    }

    public boolean isLaunchWave(int wave) {
        return this.metCondition() && wave % this.launchPeriod == 0;
    }

    public boolean canUnlock() {
        return Vars.data.isUnlocked(this) || !this.requirements.contains((Objective)((Object)((Predicate<Objective>)r -> !r.complete())));
    }

    public Array<ItemStack> getLaunchCost() {
        if (this.launchCost == null) {
            this.updateLaunchCost();
        }
        return this.launchCost;
    }

    public Array<ItemStack> getStartingItems() {
        return this.startingItems;
    }

    public void resetStartingItems() {
        this.startingItems.clear();
        this.defaultStartingItems.each(stack -> this.startingItems.add(new ItemStack(stack.item, stack.amount)));
    }

    public boolean hasLaunched() {
        return Core.settings.getBool(this.name + "-launched", false);
    }

    public void setLaunched() {
        this.updateObjectives(() -> {
            Core.settings.put(this.name + "-launched", true);
            Vars.data.modified();
        });
    }

    public void updateWave(int wave) {
        int value = Core.settings.getInt(this.name + "-wave", 0);
        if (value < wave) {
            this.updateObjectives(() -> {
                Core.settings.put(this.name + "-wave", wave);
                Vars.data.modified();
            });
        }
    }

    public void updateObjectives(Runnable closure) {
        Array<Objectives.ZoneObjective> incomplete = Vars.content.zones().map(z -> z.requirements).flatten().select(o -> o.zone() == this && !o.complete()).as(Objectives.ZoneObjective.class);
        boolean wasConfig = this.configureObjective.complete();
        closure.run();
        for (Objectives.ZoneObjective objective : incomplete) {
            if (!objective.complete()) continue;
            Events.fire(new EventType.ZoneRequireCompleteEvent(objective.zone, Vars.content.zones().find(z -> z.requirements.contains(objective)), objective));
        }
        if (!wasConfig && this.configureObjective.complete()) {
            Events.fire(new EventType.ZoneConfigureCompleteEvent(this));
        }
    }

    public int bestWave() {
        return Core.settings.getInt(this.name + "-wave", 0);
    }

    public boolean isLaunchMet() {
        return this.bestWave() >= this.conditionWave;
    }

    public void updateLaunchCost() {
        Array stacks = new Array();
        Consumer<ItemStack> adder = stack -> {
            for (ItemStack other : stacks) {
                if (other.item != stack.item) continue;
                other.amount += stack.amount;
                return;
            }
            stacks.add(new ItemStack(stack.item, stack.amount));
        };
        for (ItemStack stack2 : this.baseLaunchCost) {
            adder.accept(stack2);
        }
        for (ItemStack stack2 : this.startingItems) {
            adder.accept(stack2);
        }
        for (ItemStack stack2 : stacks) {
            if (stack2.amount >= 0) continue;
            stack2.amount = 0;
        }
        stacks.sort();
        this.launchCost = stacks;
        Core.settings.putObject(this.name + "-starting-items", this.startingItems);
        Vars.data.modified();
    }

    public boolean metCondition() {
        return Vars.state.wave >= this.conditionWave && !Vars.state.rules.attackMode;
    }

    public boolean canConfigure() {
        return this.configureObjective.complete();
    }

    @Override
    public void init() {
        if (this.generator instanceof MapGenerator && this.mod != null) {
            ((MapGenerator)this.generator).removePrefix(this.mod.name);
        }
        this.generator.init(this.loadout);
        this.resources.sort();
        for (ItemStack stack : this.startingItems) {
            this.defaultStartingItems.add(new ItemStack(stack.item, stack.amount));
        }
        Array arr = Core.settings.getObject(this.name + "-starting-items", Array.class, () -> null);
        if (arr != null) {
            this.startingItems = arr;
        }
    }

    @Override
    public boolean alwaysUnlocked() {
        return this.alwaysUnlocked;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void displayInfo(Table table) {
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("zone." + this.name + ".name");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.zone;
    }
}

