/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.type.TypeID;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.ContentDisplay;

public class UnitType
extends UnlockableContent {
    @ArcAnnotate.NonNull
    public TypeID typeID;
    @ArcAnnotate.NonNull
    public Supplier<? extends BaseUnit> constructor;
    public float health = 60.0f;
    public float hitsize = 7.0f;
    public float hitsizeTile = 4.0f;
    public float speed = 0.4f;
    public float range = 0.0f;
    public float attackLength = 150.0f;
    public float rotatespeed = 0.2f;
    public float baseRotateSpeed = 0.1f;
    public float shootCone = 15.0f;
    public float mass = 1.0f;
    public boolean flying;
    public boolean targetAir = true;
    public boolean rotateWeapon = false;
    public float drag = 0.1f;
    public float maxVelocity = 5.0f;
    public float retreatPercent = 0.6f;
    public int itemCapacity = 30;
    public ObjectSet<Item> toMine = ObjectSet.with(Items.lead, Items.copper);
    public float buildPower = 0.3f;
    public float minePower = 0.7f;
    @ArcAnnotate.NonNull
    public Weapon weapon;
    public float weaponOffsetY;
    public float engineOffset = 6.0f;
    public float engineSize = 2.0f;
    public ObjectSet<StatusEffect> immunities = new ObjectSet();
    public Sound deathSound = Sounds.bang;
    public TextureRegion legRegion;
    public TextureRegion baseRegion;
    public TextureRegion region;

    public <T extends BaseUnit> UnitType(String name, Supplier<T> mainConstructor) {
        this(name);
        this.create(mainConstructor);
    }

    public <T extends BaseUnit> UnitType(String name) {
        super(name);
        this.description = Core.bundle.getOrNull("unit." + name + ".description");
    }

    public <T extends BaseUnit> void create(Supplier<T> mainConstructor) {
        this.constructor = mainConstructor;
        this.description = Core.bundle.getOrNull("unit." + this.name + ".description");
        this.typeID = new TypeID(this.name, mainConstructor);
    }

    @Override
    public void displayInfo(Table table) {
        ContentDisplay.displayUnit(table, this);
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("unit." + this.name + ".name");
    }

    @Override
    public void load() {
        this.weapon.load();
        this.region = Core.atlas.find(this.name);
        this.legRegion = Core.atlas.find(this.name + "-leg");
        this.baseRegion = Core.atlas.find(this.name + "-base");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.unit;
    }

    public BaseUnit create(Team team) {
        BaseUnit unit = this.constructor.get();
        unit.init(this, team);
        return unit;
    }
}

