/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.ContentDisplay;

public class Mech
extends UnlockableContent {
    public boolean flying;
    public float speed = 1.1f;
    public float maxSpeed = 10.0f;
    public float boostSpeed = 0.75f;
    public float drag = 0.4f;
    public float mass = 1.0f;
    public float shake = 0.0f;
    public float health = 200.0f;
    public float hitsize = 6.0f;
    public float cellTrnsY = 0.0f;
    public float mineSpeed = 1.0f;
    public int drillPower = -1;
    public float buildPower = 1.0f;
    public Color engineColor = Pal.boostTo;
    public int itemCapacity = 30;
    public boolean turnCursor = true;
    public boolean canHeal = false;
    public float compoundSpeed;
    public float compoundSpeedBoost;
    public float weaponOffsetX;
    public float weaponOffsetY;
    public float engineOffset = 5.0f;
    public float engineSize = 2.5f;
    @ArcAnnotate.NonNull
    public Weapon weapon;
    public TextureRegion baseRegion;
    public TextureRegion legRegion;
    public TextureRegion region;

    public Mech(String name, boolean flying) {
        super(name);
        this.flying = flying;
        this.description = Core.bundle.get("mech." + name + ".description");
    }

    public Mech(String name) {
        this(name, false);
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("mech." + this.name + ".name");
    }

    public void updateAlt(Player player) {
    }

    public void draw(Player player) {
    }

    public float getExtraArmor(Player player) {
        return 0.0f;
    }

    public float spreadX(Player player) {
        return 0.0f;
    }

    public float getRotationAlpha(Player player) {
        return 1.0f;
    }

    public boolean canShoot(Player player) {
        return true;
    }

    public void onLand(Player player) {
    }

    @Override
    public void init() {
        int i;
        super.init();
        for (i = 0; i < 500; ++i) {
            this.compoundSpeed *= 1.0f - this.drag;
            this.compoundSpeed += this.speed;
        }
        for (i = 0; i < 500; ++i) {
            this.compoundSpeedBoost *= 1.0f - this.drag;
            this.compoundSpeedBoost += this.boostSpeed;
        }
    }

    @Override
    public void displayInfo(Table table) {
        ContentDisplay.displayMech(table, this);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.mech;
    }

    @Override
    public void load() {
        this.weapon.load();
        if (!this.flying) {
            this.legRegion = Core.atlas.find(this.name + "-leg");
            this.baseRegion = Core.atlas.find(this.name + "-base");
        }
        this.region = Core.atlas.find(this.name);
    }

    @Override
    public String toString() {
        return this.localizedName();
    }
}

