/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;

public class Loadout
extends Content {
    private final Array<Tile> outArray = new Array();
    private final IntMap<BlockEntry> entries = new IntMap<BlockEntry>(){
        {
            this.put(62, new BlockEntry(Blocks.conveyor, 0));
            this.put(94, new BlockEntry(Blocks.conveyor, 1));
            this.put(60, new BlockEntry(Blocks.conveyor, 2));
            this.put(118, new BlockEntry(Blocks.conveyor, 3));
            this.put(49, new BlockEntry(Blocks.coreShard));
            this.put(50, new BlockEntry(Blocks.coreFoundation));
            this.put(51, new BlockEntry(Blocks.coreNucleus));
            this.put(67, new BlockEntry(Blocks.mechanicalDrill, Blocks.oreCopper));
        }
    };
    private final IntMap<BlockEntry> blocks = new IntMap();
    private Block core;

    public Loadout(String ... layout) {
        char c;
        int x;
        int y;
        int coreX = -1;
        int coreY = -1;
        block0: for (y = 0; y < layout.length; ++y) {
            for (x = 0; x < layout[0].length(); ++x) {
                c = layout[y].charAt(x);
                if (this.entries.get(c) == null || !(this.entries.get((int)c).block instanceof CoreBlock)) continue;
                this.core = this.entries.get((int)c).block;
                coreX = x;
                coreY = y;
                break block0;
            }
        }
        if (coreX == -1) {
            throw new IllegalArgumentException("Schematic does not have a core.");
        }
        for (y = 0; y < layout.length; ++y) {
            for (x = 0; x < layout[0].length(); ++x) {
                c = layout[y].charAt(x);
                if (!this.entries.containsKey(c)) continue;
                BlockEntry entry = this.entries.get(c);
                this.blocks.put(Pos.get(x - coreX, -(y - coreY)), entry);
            }
        }
    }

    public Loadout() {
    }

    public Block core() {
        return this.core;
    }

    public void setup(int x, int y) {
        for (IntMap.Entry<BlockEntry> entry : this.blocks.entries()) {
            short ry;
            short rx = Pos.x(entry.key);
            Tile tile = Vars.world.tile(x + rx, y + (ry = Pos.y(entry.key)));
            if (tile == null) continue;
            Vars.world.setBlock(tile, ((BlockEntry)entry.value).block, Vars.defaultTeam);
            tile.rotation((byte)((BlockEntry)entry.value).rotation);
            if (((BlockEntry)entry.value).ore == null) continue;
            for (Tile t : tile.getLinkedTiles(this.outArray)) {
                t.setOverlay(((BlockEntry)entry.value).ore);
            }
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.loadout;
    }

    static class BlockEntry {
        final Block block;
        final Block ore;
        final int rotation;

        BlockEntry(Block block, Block ore) {
            this.block = block;
            this.ore = ore;
            this.rotation = 0;
        }

        BlockEntry(Block block, int rotation) {
            this.block = block;
            this.ore = null;
            this.rotation = rotation;
        }

        BlockEntry(Block block) {
            this.block = block;
            this.ore = null;
            this.rotation = 0;
        }
    }
}

