/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.ui.ContentDisplay;

public class Liquid
extends UnlockableContent {
    public final Color color;
    public float flammability;
    public float temperature = 0.5f;
    public float heatCapacity = 0.5f;
    public float viscosity = 0.5f;
    public float explosiveness;
    public Color flameColor = Color.valueOf("ffb763");
    public StatusEffect effect = StatusEffects.none;

    public Liquid(String name, Color color) {
        super(name);
        this.color = new Color(color);
        this.description = Core.bundle.getOrNull("liquid." + name + ".description");
    }

    public Liquid(String name) {
        this(name, new Color(Color.black));
    }

    public boolean canExtinguish() {
        return this.flammability < 0.1f && this.temperature <= 0.5f;
    }

    @Override
    public void displayInfo(Table table) {
        ContentDisplay.displayLiquid(table, this);
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("liquid." + this.name + ".name");
    }

    @Override
    public String toString() {
        return this.localizedName();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.liquid;
    }
}

