/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.ui.ContentDisplay;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OreBlock;

public class Item
extends UnlockableContent {
    public final Color color;
    public ItemType type = ItemType.resource;
    public float explosiveness = 0.0f;
    public float flammability = 0.0f;
    public float radioactivity;
    public int hardness = 0;
    public float cost = 1.0f;
    public boolean alwaysUnlocked = false;

    public Item(String name, Color color) {
        super(name);
        this.color = color;
        this.description = Core.bundle.getOrNull("item." + this.name + ".description");
    }

    public Item(String name) {
        this(name, new Color(Color.black));
    }

    @Override
    public boolean alwaysUnlocked() {
        return this.alwaysUnlocked;
    }

    @Override
    public void displayInfo(Table table) {
        ContentDisplay.displayItem(table, this);
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("item." + this.name + ".name");
    }

    @Override
    public String toString() {
        return this.localizedName();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.item;
    }

    public static Array<Item> getAllOres() {
        return Vars.content.blocks().select(b -> b instanceof OreBlock).map(b -> ((Floor)b).itemDrop);
    }
}

