/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.util.serialization.Base64Coder;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.io.TypeIO;
import io.anuke.mindustry.net.Packet;
import io.anuke.mindustry.net.Streamable;
import java.nio.ByteBuffer;

public class Packets {

    public static class StreamChunk
    implements Packet {
        public int id;
        public byte[] data;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(this.id);
            buffer.putShort((short)this.data.length);
            buffer.put(this.data);
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.id = buffer.getInt();
            this.data = new byte[buffer.getShort()];
            buffer.get(this.data);
        }
    }

    public static class StreamBegin
    implements Packet {
        private static int lastid;
        public int id = lastid++;
        public int total;
        public byte type;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(this.id);
            buffer.putInt(this.total);
            buffer.put(this.type);
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.id = buffer.getInt();
            this.total = buffer.getInt();
            this.type = buffer.get();
        }
    }

    public static class InvokePacket
    implements Packet {
        public byte type;
        public byte priority;
        public ByteBuffer writeBuffer;
        public int writeLength;

        @Override
        public void read(ByteBuffer buffer) {
            this.type = buffer.get();
            this.priority = buffer.get();
            this.writeLength = buffer.getShort();
            byte[] bytes = new byte[this.writeLength];
            buffer.get(bytes);
            this.writeBuffer = ByteBuffer.wrap(bytes);
        }

        @Override
        public void write(ByteBuffer buffer) {
            buffer.put(this.type);
            buffer.put(this.priority);
            buffer.putShort((short)this.writeLength);
            this.writeBuffer.position(0);
            for (int i = 0; i < this.writeLength; ++i) {
                buffer.put(this.writeBuffer.get());
            }
        }

        @Override
        public void reset() {
            this.priority = 0;
        }

        @Override
        public boolean isImportant() {
            return this.priority == 1;
        }

        @Override
        public boolean isUnimportant() {
            return this.priority == 2;
        }
    }

    public static class ConnectPacket
    implements Packet {
        public int version;
        public String versionType;
        public Array<String> mods;
        public String name;
        public String uuid;
        public String usid;
        public boolean mobile;
        public int color;

        @Override
        public void write(ByteBuffer buffer) {
            buffer.putInt(Version.build);
            TypeIO.writeString(buffer, this.versionType);
            TypeIO.writeString(buffer, this.name);
            TypeIO.writeString(buffer, this.usid);
            buffer.put(this.mobile ? (byte)1 : 0);
            buffer.putInt(this.color);
            buffer.put(Base64Coder.decode(this.uuid));
            buffer.putInt(this.mods.size);
            for (int i = 0; i < this.mods.size; ++i) {
                TypeIO.writeString(buffer, this.mods.get(i));
            }
        }

        @Override
        public void read(ByteBuffer buffer) {
            this.version = buffer.getInt();
            this.versionType = TypeIO.readString(buffer);
            this.name = TypeIO.readString(buffer);
            this.usid = TypeIO.readString(buffer);
            this.mobile = buffer.get() == 1;
            this.color = buffer.getInt();
            byte[] idbytes = new byte[8];
            buffer.get(idbytes);
            this.uuid = new String(Base64Coder.encode(idbytes));
            int totalMods = buffer.getInt();
            this.mods = new Array(totalMods);
            for (int i = 0; i < totalMods; ++i) {
                this.mods.add(TypeIO.readString(buffer));
            }
        }
    }

    public static class WorldStream
    extends Streamable {
    }

    public static class Disconnect
    implements Packet {
        public String reason;

        @Override
        public boolean isImportant() {
            return true;
        }
    }

    public static class Connect
    implements Packet {
        public String addressTCP;

        @Override
        public boolean isImportant() {
            return true;
        }
    }

    public static enum AdminAction {
        kick,
        ban,
        trace,
        wave;

    }

    public static enum KickReason {
        kick,
        clientOutdated,
        serverOutdated,
        banned,
        gameover(true),
        recentKick,
        nameInUse,
        idInUse,
        nameEmpty,
        customClient,
        serverClose,
        vote,
        typeMismatch,
        whitelist,
        playerLimit;

        public final boolean quiet;

        private KickReason() {
            this(false);
        }

        private KickReason(boolean quiet) {
            this.quiet = quiet;
        }

        public String toString() {
            return Core.bundle.get("server.kicked." + this.name());
        }

        public String extraText() {
            return Core.bundle.getOrNull("server.kicked." + this.name() + ".text");
        }
    }
}

