/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.net.Host;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class NetworkIO {
    public static void writeWorld(Player player, OutputStream os) {
        try (DataOutputStream stream = new DataOutputStream(os);){
            stream.writeUTF(JsonIO.write(Vars.state.rules));
            SaveIO.getSaveWriter().writeStringMap(stream, Vars.world.getMap().tags);
            stream.writeInt(Vars.state.wave);
            stream.writeFloat(Vars.state.wavetime);
            stream.writeInt(player.id);
            player.write(stream);
            SaveIO.getSaveWriter().writeMap(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadWorld(InputStream is) {
        try (DataInputStream stream = new DataInputStream(is);){
            Time.clear();
            Vars.state.rules = JsonIO.read(Rules.class, stream.readUTF());
            Vars.world.setMap(new Map(SaveIO.getSaveWriter().readStringMap(stream)));
            Vars.state.wave = stream.readInt();
            Vars.state.wavetime = stream.readFloat();
            Vars.entities.clear();
            int id = stream.readInt();
            Vars.player.resetNoAdd();
            Vars.player.read(stream);
            Vars.player.resetID(id);
            Vars.player.add();
            SaveIO.getSaveWriter().readMap(stream, Vars.world.context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer writeServerData() {
        String name = Vars.headless ? Core.settings.getString("servername") : Vars.player.name;
        String map = Vars.world.getMap() == null ? "None" : Vars.world.getMap().name();
        ByteBuffer buffer = ByteBuffer.allocate(256);
        NetworkIO.writeString(buffer, name, 100);
        NetworkIO.writeString(buffer, map);
        buffer.putInt(Vars.playerGroup.size());
        buffer.putInt(Vars.state.wave);
        buffer.putInt(Version.build);
        NetworkIO.writeString(buffer, Version.type);
        buffer.put((byte)Gamemode.bestFit(Vars.state.rules).ordinal());
        buffer.putInt(Vars.netServer.admins.getPlayerLimit());
        return buffer;
    }

    public static Host readServerData(String hostAddress, ByteBuffer buffer) {
        String host = NetworkIO.readString(buffer);
        String map = NetworkIO.readString(buffer);
        int players = buffer.getInt();
        int wave = buffer.getInt();
        int version = buffer.getInt();
        String vertype = NetworkIO.readString(buffer);
        Gamemode gamemode = Gamemode.all[buffer.get()];
        int limit = buffer.getInt();
        return new Host(host, hostAddress, map, wave, players, version, vertype, gamemode, limit);
    }

    private static void writeString(ByteBuffer buffer, String string, int maxlen) {
        byte[] bytes = string.getBytes(Vars.charset);
        if (bytes.length > maxlen) {
            bytes = Arrays.copyOfRange(bytes, 0, maxlen);
        }
        buffer.put((byte)bytes.length);
        buffer.put(bytes);
    }

    private static void writeString(ByteBuffer buffer, String string) {
        NetworkIO.writeString(buffer, string, 32);
    }

    private static String readString(ByteBuffer buffer) {
        short length = (short)(buffer.get() & 0xFF);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, Vars.charset);
    }
}

