/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.net.Registrator;
import io.anuke.mindustry.net.Streamable;
import java.io.IOException;

public abstract class NetConnection {
    public final String address;
    public boolean mobile;
    public boolean modclient;
    @ArcAnnotate.Nullable
    public Player player;
    public int lastRecievedClientSnapshot = -1;
    public long lastRecievedClientTime;
    public boolean hasConnected;
    public boolean hasBegunConnecting;
    public boolean hasDisconnected;
    public float viewWidth;
    public float viewHeight;
    public float viewX;
    public float viewY;

    public NetConnection(String address) {
        this.address = address;
    }

    public void kick(Packets.KickReason reason) {
        Log.info("Kicking connection {0}; Reason: {1}", this.address, reason.name());
        if (this.player != null && (reason == Packets.KickReason.kick || reason == Packets.KickReason.banned || reason == Packets.KickReason.vote) && this.player.uuid != null) {
            Administration.PlayerInfo info = Vars.netServer.admins.getInfo(this.player.uuid);
            ++info.timesKicked;
            info.lastKicked = Math.max(Time.millis(), info.lastKicked);
        }
        Call.onKick(this, reason);
        Time.runTask(2.0f, this::close);
        Vars.netServer.admins.save();
    }

    public void kick(String reason) {
        Log.info("Kicking connection {0}; Reason: {1}", this.address, reason.replace("\n", " "));
        if (this.player != null && this.player.uuid != null) {
            Administration.PlayerInfo info = Vars.netServer.admins.getInfo(this.player.uuid);
            ++info.timesKicked;
            info.lastKicked = Math.max(Time.millis(), info.lastKicked);
        }
        Call.onKick(this, reason);
        Time.runTask(2.0f, this::close);
        Vars.netServer.admins.save();
    }

    public boolean isConnected() {
        return true;
    }

    public void sendStream(Streamable stream) {
        try {
            Packets.StreamBegin begin = new Packets.StreamBegin();
            begin.total = stream.stream.available();
            begin.type = Registrator.getID(stream.getClass());
            this.send(begin, Net.SendMode.tcp);
            int cid = begin.id;
            while (stream.stream.available() > 0) {
                byte[] bytes = new byte[Math.min(512, stream.stream.available())];
                stream.stream.read(bytes);
                Packets.StreamChunk chunk = new Packets.StreamChunk();
                chunk.id = cid;
                chunk.data = bytes;
                this.send(chunk, Net.SendMode.tcp);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void send(Object var1, Net.SendMode var2);

    public abstract void close();
}

