/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.function.BiConsumer;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.net.Host;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.Packet;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.net.Streamable;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class Net {
    private boolean server;
    private boolean active;
    private boolean clientLoaded;
    @ArcAnnotate.Nullable
    private Streamable.StreamBuilder currentStream;
    private final Array<Object> packetQueue = new Array();
    private final ObjectMap<Class<?>, Consumer> clientListeners = new ObjectMap();
    private final ObjectMap<Class<?>, BiConsumer<NetConnection, Object>> serverListeners = new ObjectMap();
    private final IntMap<Streamable.StreamBuilder> streams = new IntMap();
    private final NetProvider provider;
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();

    public Net(NetProvider provider) {
        this.provider = provider;
    }

    public void showError(Throwable e) {
        if (!Vars.headless) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            String baseError = Strings.getFinalMesage(e);
            String error = baseError == null ? "" : baseError.toLowerCase();
            String type = t.getClass().toString().toLowerCase();
            boolean isError = false;
            if (e instanceof BufferUnderflowException || e instanceof BufferOverflowException) {
                error = Core.bundle.get("error.io");
            } else if (error.equals("mismatch")) {
                error = Core.bundle.get("error.mismatch");
            } else if (error.contains("port out of range") || error.contains("invalid argument") || error.contains("invalid") && error.contains("address") || Strings.parseException(e, true).contains("address associated")) {
                error = Core.bundle.get("error.invalidaddress");
            } else if (error.contains("connection refused") || error.contains("route to host") || type.contains("unknownhost")) {
                error = Core.bundle.get("error.unreachable");
            } else if (type.contains("timeout")) {
                error = Core.bundle.get("error.timedout");
            } else if (error.equals("alreadyconnected") || error.contains("connection is closed")) {
                error = Core.bundle.get("error.alreadyconnected");
            } else if (!error.isEmpty()) {
                error = Core.bundle.get("error.any");
                isError = true;
            }
            if (isError) {
                Vars.ui.showException("$error.any", e);
            } else {
                Vars.ui.showText("", Core.bundle.format("connectfail", error));
            }
            Vars.ui.loadfrag.hide();
            if (this.client()) {
                Vars.netClient.disconnectQuietly();
            }
        }
        Log.err(e);
    }

    public void setClientLoaded(boolean loaded) {
        this.clientLoaded = loaded;
        if (loaded) {
            for (int i = 0; i < this.packetQueue.size; ++i) {
                this.handleClientReceived(this.packetQueue.get(i));
            }
        }
        this.packetQueue.clear();
    }

    public void setClientConnected() {
        this.active = true;
        this.server = false;
    }

    public void connect(String ip, int port, Runnable success) {
        try {
            if (this.active) {
                throw new IOException("alreadyconnected");
            }
            this.provider.connectClient(ip, port, success);
            this.active = true;
            this.server = false;
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    public void host(int port) throws IOException {
        this.provider.hostServer(port);
        this.active = true;
        this.server = true;
        Time.runTask(60.0f, Vars.platform::updateRPC);
    }

    public void closeServer() {
        for (NetConnection con : this.getConnections()) {
            Call.onKick(con, Packets.KickReason.serverClose);
        }
        this.provider.closeServer();
        this.server = false;
        this.active = false;
    }

    public void reset() {
        this.closeServer();
        Vars.netClient.disconnectNoReset();
    }

    public void disconnect() {
        this.provider.disconnectClient();
        this.server = false;
        this.active = false;
    }

    public byte[] compressSnapshot(byte[] input) {
        return this.compressor.compress(input);
    }

    public byte[] decompressSnapshot(byte[] input, int size) {
        return this.decompressor.decompress(input, size);
    }

    public void discoverServers(Consumer<Host> cons, Runnable done) {
        this.provider.discoverServers(cons, done);
    }

    public Iterable<NetConnection> getConnections() {
        return this.provider.getConnections();
    }

    public void send(Object object, SendMode mode) {
        if (this.server) {
            for (NetConnection netConnection : this.provider.getConnections()) {
                netConnection.send(object, mode);
            }
        } else {
            this.provider.sendClient(object, mode);
        }
    }

    public void sendExcept(NetConnection except, Object object, SendMode mode) {
        for (NetConnection con : this.getConnections()) {
            if (con == except) continue;
            con.send(object, mode);
        }
    }

    @ArcAnnotate.Nullable
    public Streamable.StreamBuilder getCurrentStream() {
        return this.currentStream;
    }

    public <T> void handleClient(Class<T> type, Consumer<T> listener) {
        this.clientListeners.put(type, listener);
    }

    public <T> void handleServer(Class<T> type, BiConsumer<NetConnection, T> listener) {
        this.serverListeners.put(type, listener);
    }

    public void handleClientReceived(Object object) {
        if (object instanceof Packets.StreamBegin) {
            Packets.StreamBegin b = (Packets.StreamBegin)object;
            this.currentStream = new Streamable.StreamBuilder(b);
            this.streams.put(b.id, this.currentStream);
        } else if (object instanceof Packets.StreamChunk) {
            Packets.StreamChunk c = (Packets.StreamChunk)object;
            Streamable.StreamBuilder builder = this.streams.get(c.id);
            if (builder == null) {
                throw new RuntimeException("Recieved stream chunk without a StreamBegin beforehand!");
            }
            builder.add(c.data);
            if (builder.isDone()) {
                this.streams.remove(builder.id);
                this.handleClientReceived(builder.build());
                this.currentStream = null;
            }
        } else if (this.clientListeners.get(object.getClass()) != null) {
            if (this.clientLoaded || object instanceof Packet && ((Packet)object).isImportant()) {
                if (this.clientListeners.get(object.getClass()) != null) {
                    this.clientListeners.get(object.getClass()).accept(object);
                }
                Pools.free(object);
            } else if (!(object instanceof Packet) || !((Packet)object).isUnimportant()) {
                this.packetQueue.add(object);
            } else {
                Pools.free(object);
            }
        } else {
            Log.err("Unhandled packet type: '{0}'!", object);
        }
    }

    public void handleServerReceived(NetConnection connection, Object object) {
        if (this.serverListeners.get(object.getClass()) != null) {
            if (this.serverListeners.get(object.getClass()) != null) {
                this.serverListeners.get(object.getClass()).accept(connection, object);
            }
            Pools.free(object);
        } else {
            Log.err("Unhandled packet type: '{0}'!", object.getClass());
        }
    }

    public void pingHost(String address, int port, Consumer<Host> valid, Consumer<Exception> failed) {
        this.provider.pingHost(address, port, valid, failed);
    }

    public boolean active() {
        return this.active;
    }

    public boolean server() {
        return this.server && this.active;
    }

    public boolean client() {
        return !this.server && this.active;
    }

    public void dispose() {
        this.provider.dispose();
        this.server = false;
        this.active = false;
    }

    public static interface NetProvider {
        public void connectClient(String var1, int var2, Runnable var3) throws IOException;

        public void sendClient(Object var1, SendMode var2);

        public void disconnectClient();

        public void discoverServers(Consumer<Host> var1, Runnable var2);

        public void pingHost(String var1, int var2, Consumer<Host> var3, Consumer<Exception> var4);

        public void hostServer(int var1) throws IOException;

        public Iterable<? extends NetConnection> getConnections();

        public void closeServer();

        default public void dispose() {
            this.disconnectClient();
            this.closeServer();
        }
    }

    public static enum SendMode {
        tcp,
        udp;

    }
}

