/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;

public class Interpolator {
    public Vector2 target = new Vector2();
    public Vector2 last = new Vector2();
    public float[] targets = new float[0];
    public float[] lasts = new float[0];
    public long lastUpdated;
    public long updateSpacing;
    public Vector2 pos = new Vector2();
    public float[] values = new float[0];

    public void read(float cx, float cy, float x, float y, float ... target1ds) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.targets = target1ds;
        if (this.lasts.length != this.values.length) {
            this.lasts = new float[this.values.length];
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.lasts[i] = this.values[i];
        }
        this.last.set(cx, cy);
        this.target.set(x, y);
    }

    public void reset() {
        this.values = new float[0];
        this.targets = new float[0];
        this.target.setZero();
        this.last.setZero();
        this.lastUpdated = 0L;
        this.updateSpacing = 16L;
        this.pos.setZero();
    }

    public void update() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis(this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.pos.set(this.last).lerpPast(this.target, alpha);
            if (this.values.length != this.targets.length) {
                this.values = new float[this.targets.length];
            }
            if (this.lasts.length != this.targets.length) {
                this.lasts = new float[this.targets.length];
            }
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = Mathf.slerp(this.lasts[i], this.targets[i], alpha);
            }
        } else {
            this.pos.set(this.target);
        }
    }
}

