/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.mindustry.Vars;

public class Administration {
    private ObjectMap<String, PlayerInfo> playerInfo = new ObjectMap();
    private Array<String> bannedIPs = new Array();
    private Array<String> whitelist = new Array();

    public Administration() {
        Core.settings.defaults("strict", true, "servername", "Server");
        this.load();
    }

    public int getPlayerLimit() {
        return Core.settings.getInt("playerlimit", 0);
    }

    public void setPlayerLimit(int limit) {
        Core.settings.putSave("playerlimit", limit);
    }

    public void setStrict(boolean on) {
        Core.settings.putSave("strict", on);
    }

    public boolean getStrict() {
        return Core.settings.getBool("strict");
    }

    public boolean allowsCustomClients() {
        return Core.settings.getBool("allow-custom", !Vars.headless);
    }

    public void setCustomClients(boolean allowed) {
        Core.settings.put("allow-custom", allowed);
        Core.settings.save();
    }

    public void updatePlayerJoined(String id, String ip, String name) {
        PlayerInfo info = this.getCreateInfo(id);
        info.lastName = name;
        info.lastIP = ip;
        ++info.timesJoined;
        if (!info.names.contains(name, false)) {
            info.names.add(name);
        }
        if (!info.ips.contains(ip, false)) {
            info.ips.add(ip);
        }
    }

    public boolean banPlayer(String uuid) {
        return this.banPlayerID(uuid) || this.banPlayerIP(this.getInfo((String)uuid).lastIP);
    }

    public boolean banPlayerIP(String ip) {
        if (this.bannedIPs.contains(ip, false)) {
            return false;
        }
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            info.banned = true;
        }
        this.bannedIPs.add(ip);
        this.save();
        return true;
    }

    public boolean banPlayerID(String id) {
        if (this.playerInfo.containsKey(id) && this.playerInfo.get((String)id).banned) {
            return false;
        }
        this.getCreateInfo((String)id).banned = true;
        this.save();
        return true;
    }

    public boolean unbanPlayerIP(String ip) {
        boolean found = this.bannedIPs.contains(ip, false);
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            info.banned = false;
            found = true;
        }
        this.bannedIPs.removeValue(ip, false);
        if (found) {
            this.save();
        }
        return found;
    }

    public boolean unbanPlayerID(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (!info.banned) {
            return false;
        }
        info.banned = false;
        this.bannedIPs.removeAll(info.ips, false);
        this.save();
        return true;
    }

    public Array<PlayerInfo> getAdmins() {
        Array<PlayerInfo> result = new Array<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.admin) continue;
            result.add(info);
        }
        return result;
    }

    public Array<PlayerInfo> getBanned() {
        Array<PlayerInfo> result = new Array<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.banned) continue;
            result.add(info);
        }
        return result;
    }

    public Array<String> getBannedIPs() {
        return this.bannedIPs;
    }

    public boolean adminPlayer(String id, String usid) {
        PlayerInfo info = this.getCreateInfo(id);
        if (info.admin && info.adminUsid != null && info.adminUsid.equals(usid)) {
            return false;
        }
        info.adminUsid = usid;
        info.admin = true;
        this.save();
        return true;
    }

    public boolean unAdminPlayer(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (!info.admin) {
            return false;
        }
        info.admin = false;
        this.save();
        return true;
    }

    public boolean isWhitelistEnabled() {
        return Core.settings.getBool("whitelist", false);
    }

    public void setWhitelist(boolean enabled) {
        Core.settings.putSave("whitelist", enabled);
    }

    public boolean isWhitelisted(String id, String usid) {
        return !this.isWhitelistEnabled() || this.whitelist.contains(usid + id);
    }

    public boolean whitelist(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (this.whitelist.contains(info.adminUsid + id)) {
            return false;
        }
        this.whitelist.add(info.adminUsid + id);
        this.save();
        return true;
    }

    public boolean unwhitelist(String id) {
        PlayerInfo info = this.getCreateInfo(id);
        if (this.whitelist.contains(info.adminUsid + id)) {
            this.whitelist.remove(info.adminUsid + id);
            this.save();
            return true;
        }
        return false;
    }

    public boolean isIPBanned(String ip) {
        return this.bannedIPs.contains(ip, false) || this.findByIP(ip) != null && this.findByIP((String)ip).banned;
    }

    public boolean isIDBanned(String uuid) {
        return this.getCreateInfo((String)uuid).banned;
    }

    public boolean isAdmin(String id, String usid) {
        PlayerInfo info = this.getCreateInfo(id);
        return info.admin && usid.equals(info.adminUsid);
    }

    public ObjectSet<PlayerInfo> findByName(String name) {
        ObjectSet<PlayerInfo> result = new ObjectSet<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.lastName.toLowerCase().equals(name.toLowerCase()) && !info.names.contains(name, false) && !info.ips.contains(name, false) && !info.id.equals(name)) continue;
            result.add(info);
        }
        return result;
    }

    public Array<PlayerInfo> findByIPs(String ip) {
        Array<PlayerInfo> result = new Array<PlayerInfo>();
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            result.add(info);
        }
        return result;
    }

    public PlayerInfo getInfo(String id) {
        return this.getCreateInfo(id);
    }

    public PlayerInfo getInfoOptional(String id) {
        return this.playerInfo.get(id);
    }

    public PlayerInfo findByIP(String ip) {
        for (PlayerInfo info : this.playerInfo.values()) {
            if (!info.ips.contains(ip, false)) continue;
            return info;
        }
        return null;
    }

    public Array<PlayerInfo> getWhitelisted() {
        return this.playerInfo.values().toArray().select(p -> this.isWhitelisted(p.id, p.adminUsid));
    }

    private PlayerInfo getCreateInfo(String id) {
        if (this.playerInfo.containsKey(id)) {
            return this.playerInfo.get(id);
        }
        PlayerInfo info = new PlayerInfo(id);
        this.playerInfo.put(id, info);
        this.save();
        return info;
    }

    public void save() {
        Core.settings.putObject("player-info", this.playerInfo);
        Core.settings.putObject("banned-ips", this.bannedIPs);
        Core.settings.putObject("whitelisted", this.whitelist);
        Core.settings.save();
    }

    private void load() {
        this.playerInfo = Core.settings.getObject("player-info", ObjectMap.class, ObjectMap::new);
        this.bannedIPs = Core.settings.getObject("banned-ips", Array.class, Array::new);
        this.whitelist = Core.settings.getObject("whitelisted", Array.class, Array::new);
    }

    public static class TraceInfo {
        public String ip;
        public String uuid;
        public boolean modded;
        public boolean mobile;

        public TraceInfo(String ip, String uuid, boolean modded, boolean mobile) {
            this.ip = ip;
            this.uuid = uuid;
            this.modded = modded;
            this.mobile = mobile;
        }
    }

    public static class PlayerInfo {
        public String id;
        public String lastName = "<unknown>";
        public String lastIP = "<unknown>";
        public Array<String> ips = new Array();
        public Array<String> names = new Array();
        public String adminUsid;
        public int timesKicked;
        public int timesJoined;
        public boolean banned;
        public boolean admin;
        public long lastKicked;

        PlayerInfo(String id) {
            this.id = id;
        }

        public PlayerInfo() {
        }
    }
}

