/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.mod;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.Loadable;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.files.ZipFileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.PixmapPacker;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.I18NBundle;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.io.PropertiesUtils;
import io.anuke.arc.util.io.Streams;
import io.anuke.arc.util.serialization.Json;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.Version;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Musics;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.mod.ContentParser;
import io.anuke.mindustry.mod.Mod;
import io.anuke.mindustry.plugin.Plugin;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Publishable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public class Mods
implements Loadable {
    private Json json = new Json();
    private ContentParser parser = new ContentParser();
    private ObjectMap<String, Array<FileHandle>> bundles = new ObjectMap();
    private ObjectSet<String> specialFolders = ObjectSet.with("bundles", "sprites");
    private int totalSprites;
    private PixmapPacker packer;
    private Array<LoadedMod> loaded = new Array();
    private Array<LoadedMod> disabled = new Array();
    private ObjectMap<Class<?>, ModMeta> metas = new ObjectMap();
    private boolean requiresReload;

    public FileHandle getConfig(Mod mod) {
        ModMeta load = this.metas.get(mod.getClass());
        if (load == null) {
            throw new IllegalArgumentException("Mod is not loaded yet (or missing)!");
        }
        return Vars.modDirectory.child(load.name).child("config.json");
    }

    @ArcAnnotate.Nullable
    public LoadedMod getMod(Class<? extends Mod> type) {
        return this.loaded.find(l -> l.mod.getClass() == type);
    }

    public void importMod(FileHandle file) throws IOException {
        FileHandle dest = Vars.modDirectory.child(file.name());
        if (dest.exists()) {
            throw new IOException("A mod with the same filename already exists!");
        }
        file.copyTo(dest);
        try {
            this.loaded.add(this.loadMod(dest));
            this.requiresReload = true;
        }
        catch (IOException e) {
            dest.delete();
            throw e;
        }
        catch (Throwable t) {
            dest.delete();
            throw new IOException(t);
        }
    }

    @Override
    public void loadAsync() {
        if (this.loaded.isEmpty()) {
            return;
        }
        Time.mark();
        this.packer = new PixmapPacker(2048, 2048, Pixmap.Format.RGBA8888, 2, true);
        for (LoadedMod mod : this.loaded) {
            int[] packed = new int[]{0};
            boolean[] failed = new boolean[]{false};
            mod.root.child("sprites").walk(file -> {
                if (failed[0]) {
                    return;
                }
                if (file.extension().equals("png")) {
                    try (InputStream stream = file.read();){
                        byte[] bytes = Streams.copyStreamToByteArray(stream, Math.max((int)file.length(), 512));
                        Pixmap pixmap = new Pixmap(bytes, 0, bytes.length);
                        this.packer.pack(mod.name + "-" + file.nameWithoutExtension(), pixmap);
                        pixmap.dispose();
                        packed[0] = packed[0] + 1;
                        ++this.totalSprites;
                    }
                    catch (IOException e) {
                        failed[0] = true;
                        Core.app.post(() -> {
                            Log.err("Error packing images for mod: {0}", mod.meta.name);
                            e.printStackTrace();
                            if (!Vars.headless) {
                                Vars.ui.showException(e);
                            }
                        });
                    }
                }
            });
            Log.info("Packed {0} images for mod '{1}'.", packed[0], mod.meta.name);
        }
        Log.info("Time to pack textures: {0}", Float.valueOf(Time.elapsed()));
    }

    @Override
    public void loadSync() {
        if (this.packer == null) {
            return;
        }
        Time.mark();
        Texture editor = Core.atlas.find("clear-editor").getTexture();
        PixmapPacker editorPacker = new PixmapPacker(2048, 2048, Pixmap.Format.RGBA8888, 2, true);
        for (TextureAtlas.AtlasRegion region : Core.atlas.getRegions()) {
            if (region.getTexture() != editor) continue;
            editorPacker.pack(region.name, Core.atlas.getPixmap(region).crop());
        }
        if (this.totalSprites > 0) {
            Texture.TextureFilter filter = Core.settings.getBool("linear") ? Texture.TextureFilter.Linear : Texture.TextureFilter.Nearest;
            this.packer.updateTextureAtlas(Core.atlas, filter, filter, false);
            for (Array<Content> arr : Vars.content.getContentMap()) {
                arr.each((? super T c) -> {
                    if (c instanceof UnlockableContent && c.mod != null) {
                        UnlockableContent u = (UnlockableContent)c;
                        u.createIcons(this.packer, editorPacker);
                    }
                });
            }
            editorPacker.updateTextureAtlas(Core.atlas, filter, filter, false);
            this.packer.updateTextureAtlas(Core.atlas, filter, filter, false);
        }
        this.packer.dispose();
        this.packer = null;
        Log.info("Time to update textures: {0}", Float.valueOf(Time.elapsed()));
    }

    public void removeMod(LoadedMod mod) {
        if (mod.file.isDirectory()) {
            mod.file.deleteDirectory();
        } else {
            mod.file.delete();
        }
        this.loaded.remove(mod);
        this.disabled.remove(mod);
        this.requiresReload = true;
    }

    public boolean requiresReload() {
        return this.requiresReload;
    }

    public void load() {
        for (FileHandle file : Vars.modDirectory.list()) {
            if (!file.extension().equals("jar") && !file.extension().equals("zip") && (!file.isDirectory() || !file.child("mod.json").exists())) continue;
            Log.debug("[Mods] Loading mod {0}", file);
            try {
                LoadedMod mod = this.loadMod(file);
                if (mod.enabled() || Vars.headless) {
                    this.loaded.add(mod);
                    continue;
                }
                this.disabled.add(mod);
            }
            catch (Exception e) {
                Log.err("Failed to load mod file {0}. Skipping.", file);
                Log.err(e);
            }
        }
        for (FileHandle file : Vars.platform.getWorkshopContent(LoadedMod.class)) {
            try {
                LoadedMod mod = this.loadMod(file);
                if (mod.enabled()) {
                    this.loaded.add(mod);
                } else {
                    this.disabled.add(mod);
                }
                mod.addSteamID(file.parent().name());
            }
            catch (Exception e) {
                Log.err("Failed to load mod workshop file {0}. Skipping.", file);
                Log.err(e);
            }
        }
        this.loaded.sort(Structs.comparing(m -> m.name));
        this.buildFiles();
    }

    private void buildFiles() {
        for (LoadedMod mod : this.loaded) {
            boolean zipFolder = !mod.file.isDirectory() && mod.root.parent() != null;
            String parentName = zipFolder ? mod.root.name() : null;
            for (FileHandle file : mod.root.list()) {
                if (!file.isDirectory() || this.specialFolders.contains(file.name())) continue;
                file.walk(f -> Vars.tree.addFile(mod.file.isDirectory() ? f.path().substring(1 + mod.file.path().length()) : (zipFolder ? f.path().substring(parentName.length() + 1) : f.path()), (FileHandle)f));
            }
            FileHandle folder = mod.root.child("bundles");
            if (!folder.exists()) continue;
            for (FileHandle file : folder.list()) {
                if (!file.name().startsWith("bundle") || !file.extension().equals("properties")) continue;
                String name = file.nameWithoutExtension();
                this.bundles.getOr(name, Array::new).add(file);
            }
        }
        for (I18NBundle bundle = Core.bundle; bundle != null; bundle = bundle.getParent()) {
            String str = bundle.getLocale().toString();
            String locale = "bundle" + (str.isEmpty() ? "" : "_" + str);
            for (FileHandle file : this.bundles.getOr(locale, Array::new)) {
                try {
                    PropertiesUtils.load(bundle.getProperties(), file.reader());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error loading bundle: " + file + "/" + locale, e);
                }
            }
        }
    }

    public void reloadContent() {
        Core.atlas = new TextureAtlas(Core.files.internal("sprites/sprites.atlas"));
        this.loaded.clear();
        this.disabled.clear();
        this.load();
        this.buildFiles();
        Musics.dispose();
        Sounds.dispose();
        Musics.load();
        Sounds.load();
        Core.assets.finishLoading();
        Vars.content.clear();
        Vars.content.createContent();
        this.loadAsync();
        this.loadSync();
        Vars.content.init();
        Vars.content.load();
        Vars.content.loadColors();
        Vars.data.load();
        this.requiresReload = false;
        Events.fire(new EventType.ContentReloadEvent());
    }

    public void loadContent() {
        for (LoadedMod mod : this.loaded) {
            this.safeRun(mod, () -> {
                if (mod.root.child("content").exists()) {
                    FileHandle contentRoot = mod.root.child("content");
                    for (ContentType type : ContentType.all) {
                        FileHandle folder = contentRoot.child(type.name().toLowerCase() + "s");
                        if (!folder.exists()) continue;
                        for (FileHandle file : folder.list()) {
                            if (!file.extension().equals("json")) continue;
                            try {
                                Content loaded = this.parser.parse(mod, file.nameWithoutExtension(), file.readString("UTF-8"), file, type);
                                Log.debug("[{0}] Loaded '{1}'.", mod.meta.name, loaded instanceof UnlockableContent ? ((UnlockableContent)loaded).localizedName : loaded);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Failed to parse content file '" + file + "' for mod '" + mod.meta.name + "'.", e);
                            }
                        }
                    }
                }
            });
        }
        this.parser.finishParsing();
        this.each(Mod::loadContent);
    }

    public Array<LoadedMod> all() {
        return this.loaded;
    }

    public Array<LoadedMod> disabled() {
        return this.disabled;
    }

    public Array<String> getModNames() {
        return this.loaded.select(l -> !l.meta.hidden).map(l -> l.name + ":" + l.meta.version);
    }

    public Array<String> getModStrings() {
        return this.loaded.select(l -> !l.meta.hidden).map(l -> l.name + ":" + l.meta.version);
    }

    public void setEnabled(LoadedMod mod, boolean enabled) {
        if (mod.enabled() != enabled) {
            Core.settings.putSave("mod-" + mod.name + "-enabled", enabled);
            Core.settings.save();
            this.requiresReload = true;
            if (!enabled) {
                this.loaded.remove(mod);
                this.disabled.add(mod);
            } else {
                this.loaded.add(mod);
                this.disabled.remove(mod);
            }
        }
    }

    public Array<String> getIncompatibility(Array<String> out) {
        Array<String> mods = this.getModStrings();
        Array<String> result = mods.copy();
        for (String mod : mods) {
            if (!out.remove(mod)) continue;
            result.remove(mod);
        }
        return result;
    }

    public void each(Consumer<Mod> cons) {
        this.loaded.each(p -> p.mod != null, p -> this.safeRun((LoadedMod)p, () -> cons.accept(p.mod)));
    }

    public void handleError(Throwable t, LoadedMod mod) {
        Array<Throwable> causes = Strings.getCauses(t);
        Content content = null;
        for (Throwable e : causes) {
            if (!(e instanceof ModLoadException) || ((ModLoadException)e).content == null) continue;
            content = ((ModLoadException)e).content;
        }
        String realCause = "<???>";
        for (int i = causes.size - 1; i >= 0; --i) {
            if (causes.get(i).getMessage() == null) continue;
            realCause = causes.get(i).getMessage();
            break;
        }
        this.setEnabled(mod, false);
        if (content != null) {
            throw new ModLoadException(Strings.format("Error loading '{0}' from mod '{1}' ({2}):\n{3}", content, mod.meta.name, content.sourceFile.name(), realCause), content, t);
        }
        throw new ModLoadException("Error loading mod " + mod.meta.name, t);
    }

    public void safeRun(LoadedMod mod, Runnable run) {
        try {
            run.run();
        }
        catch (Throwable t) {
            this.handleError(t, mod);
        }
    }

    private LoadedMod loadMod(FileHandle sourceFile) throws Exception {
        Mod mainMod;
        String[] path;
        FileHandle metaf;
        FileHandle zip;
        FileHandle fileHandle = zip = sourceFile.isDirectory() ? sourceFile : new ZipFileHandle(sourceFile);
        if (zip.list().length == 1 && zip.list()[0].isDirectory()) {
            zip = zip.list()[0];
        }
        FileHandle fileHandle2 = metaf = zip.child("mod.json").exists() ? zip.child("mod.json") : zip.child("plugin.json");
        if (!metaf.exists()) {
            Log.warn("Mod {0} doesn't have a 'mod.json'/'plugin.json' file, skipping.", sourceFile);
            throw new IllegalArgumentException("No mod.json found.");
        }
        ModMeta meta = this.json.fromJson(ModMeta.class, metaf.readString());
        String camelized = meta.name.replace(" ", "");
        String mainClass = meta.main == null ? camelized.toLowerCase() + "." + camelized + "Mod" : meta.main;
        String baseName = meta.name.toLowerCase().replace(" ", "-");
        if (this.loaded.contains((LoadedMod)((Object)((Predicate<LoadedMod>)m -> m.name.equals(baseName)))) || this.disabled.contains((LoadedMod)((Object)((Predicate<LoadedMod>)m -> m.name.equals(baseName))))) {
            throw new IllegalArgumentException("A mod with the name '" + baseName + "' is already imported.");
        }
        FileHandle mainFile = zip;
        for (String str : path = (mainClass.replace('.', '/') + ".class").split("/")) {
            if (str.isEmpty()) continue;
            mainFile = mainFile.child(str);
        }
        if (mainFile.exists()) {
            if (!Vars.headless && Version.build != -1) {
                throw new IllegalArgumentException("Java class mods are currently unsupported outside of custom builds.");
            }
            URLClassLoader classLoader = new URLClassLoader(new URL[]{sourceFile.file().toURI().toURL()}, ClassLoader.getSystemClassLoader());
            Class<?> main = classLoader.loadClass(mainClass);
            this.metas.put(main, meta);
            mainMod = (Mod)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            mainMod = null;
        }
        if (mainMod instanceof Plugin) {
            meta.hidden = true;
        }
        return new LoadedMod(sourceFile, zip, mainMod, meta);
    }

    public static class ModLoadException
    extends RuntimeException {
        public Content content;
        public LoadedMod mod;

        public ModLoadException(String message, Throwable cause) {
            super(message, cause);
        }

        public ModLoadException(String message, @ArcAnnotate.Nullable Content content, Throwable cause) {
            super(message, cause);
            this.content = content;
            if (content != null) {
                this.mod = content.mod;
            }
        }

        public ModLoadException(@ArcAnnotate.Nullable Content content, Throwable cause) {
            super(cause);
            this.content = content;
            if (content != null) {
                this.mod = content.mod;
            }
        }
    }

    public static class ModMeta {
        public String name;
        public String author;
        public String description;
        public String version;
        public String main;
        public String[] dependencies = new String[0];
        public boolean hidden;
    }

    public static class LoadedMod
    implements Publishable {
        public final FileHandle file;
        public final FileHandle root;
        @ArcAnnotate.Nullable
        public final Mod mod;
        public final String name;
        public final ModMeta meta;

        public LoadedMod(FileHandle file, FileHandle root, Mod mod, ModMeta meta) {
            this.root = root;
            this.file = file;
            this.mod = mod;
            this.meta = meta;
            this.name = meta.name.toLowerCase().replace(" ", "-");
        }

        public boolean enabled() {
            return Core.settings.getBool("mod-" + this.name + "-enabled", true);
        }

        @Override
        public String getSteamID() {
            return Core.settings.getString(this.name + "-steamid", null);
        }

        @Override
        public void addSteamID(String id) {
            Core.settings.put(this.name + "-steamid", id);
            Core.settings.save();
        }

        @Override
        public void removeSteamID() {
            Core.settings.remove(this.name + "-steamid");
            Core.settings.save();
        }

        @Override
        public String steamTitle() {
            return this.meta.name;
        }

        @Override
        public String steamDescription() {
            return this.meta.description;
        }

        @Override
        public String steamTag() {
            return "mod";
        }

        @Override
        public FileHandle createSteamFolder(String id) {
            return this.file;
        }

        @Override
        public FileHandle createSteamPreview(String id) {
            return this.file.child("preview.png");
        }

        @Override
        public boolean prePublish() {
            if (!this.file.isDirectory()) {
                Vars.ui.showErrorMessage("$mod.folder.missing");
                return false;
            }
            if (!this.file.child("preview.png").exists()) {
                Vars.ui.showErrorMessage("$mod.preview.missing");
                return false;
            }
            return true;
        }

        public String toString() {
            return "LoadedMod{file=" + this.file + ", root=" + this.root + ", name='" + this.name + '\'' + '}';
        }
    }
}

