/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.mod;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Colors;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.ui.Fonts;

public class ModCrashHandler {
    public static void handle(Throwable t) {
        Array<Throwable> list = Strings.getCauses(t);
        Throwable modCause = list.find(e -> e instanceof Mods.ModLoadException);
        if (modCause == null || Fonts.outline == null) {
            throw new RuntimeException(t);
        }
        final String text = "[scarlet][[A fatal crash has occured while loading a mod!][]\n\nReason:[accent] " + modCause.getMessage();
        final String bottom = "[scarlet]The associated mod has been disabled. Swipe out of the app and launch it again.";
        final GlyphLayout layout = new GlyphLayout();
        Core.atlas = TextureAtlas.blankAtlas();
        Colors.put("accent", Pal.accent);
        Core.app.addListener(new ApplicationListener(){

            @Override
            public void update() {
                Core.graphics.clear(0.1f, 0.1f, 0.1f, 1.0f);
                float rad = (float)Math.min(Core.graphics.getWidth(), Core.graphics.getHeight()) / 2.0f / 1.3f;
                Draw.color(Color.scarlet, Color.black, Mathf.absin(Core.graphics.getFrameId(), 15.0f, 0.6f));
                Lines.stroke(Scl.scl(40.0f));
                float cx = (float)Core.graphics.getWidth() / 2.0f;
                float cy = (float)Core.graphics.getHeight() / 2.0f;
                for (int i = 0; i < 3; ++i) {
                    float angle1 = (float)i * 120.0f + 90.0f;
                    float angle2 = (float)(i + 1) * 120.0f + 90.0f;
                    Tmp.v1.trnsExact(angle1, rad - Lines.getStroke() / 2.0f).add(cx, cy);
                    Tmp.v2.trnsExact(angle2, rad - Lines.getStroke() / 2.0f).add(cx, cy);
                    Tmp.v3.trnsExact(angle1, rad + Lines.getStroke() / 2.0f).add(cx, cy);
                    Tmp.v4.trnsExact(angle2, rad + Lines.getStroke() / 2.0f).add(cx, cy);
                    Fill.quad(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y, Tmp.v4.x, Tmp.v4.y, Tmp.v3.x, Tmp.v3.y);
                }
                Lines.lineAngleCenter((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f - Scl.scl(5.0f), 90.0f, rad / 3.1f);
                Fill.square((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f + rad / 2.0f - Scl.scl(15.0f), Lines.getStroke() / 2.0f);
                Draw.reset();
                Fonts.outline.getData().markupEnabled = true;
                layout.setText(Fonts.outline, text, Color.white, Core.graphics.getWidth(), 8, true);
                Fonts.outline.draw(text, (float)Core.graphics.getWidth() / 2.0f - layout.width / 2.0f, (float)Core.graphics.getHeight() - Scl.scl(50.0f), Core.graphics.getWidth(), 8, true);
                layout.setText(Fonts.outline, bottom, Color.white, Core.graphics.getWidth(), 8, true);
                Fonts.outline.draw(bottom, (float)Core.graphics.getWidth() / 2.0f - layout.width / 2.0f, layout.height + Scl.scl(10.0f), Core.graphics.getWidth(), 8, true);
                Draw.flush();
            }

            @Override
            public void resize(int width, int height) {
                Draw.proj().setOrtho(0.0f, 0.0f, width, height);
            }
        });
    }
}

