/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.mod;

import io.anuke.arc.Core;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.audio.mock.MockSound;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Function;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.util.ArcAnnotate;
import io.anuke.arc.util.I18NBundle;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.reflect.Field;
import io.anuke.arc.util.reflect.ReflectionException;
import io.anuke.arc.util.serialization.Json;
import io.anuke.arc.util.serialization.JsonValue;
import io.anuke.arc.util.serialization.SerializationException;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Loadouts;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.TechTree;
import io.anuke.mindustry.ctype.Content;
import io.anuke.mindustry.ctype.UnlockableContent;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BasicBulletType;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.game.Objective;
import io.anuke.mindustry.game.Objectives;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.mod.ModLoadingSound;
import io.anuke.mindustry.mod.Mods;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.Loadout;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.type.Zone;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.consumers.Consume;
import io.anuke.mindustry.world.consumers.ConsumeItems;
import io.anuke.mindustry.world.consumers.ConsumeLiquid;
import io.anuke.mindustry.world.consumers.ConsumePower;
import io.anuke.mindustry.world.meta.BuildVisibility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ContentParser {
    private static final boolean ignoreUnknownFields = true;
    private ObjectMap<Class<?>, ContentType> contentTypes = new ObjectMap();
    private ObjectMap<Class<?>, FieldParser> classParsers = new ObjectMap<Class<?>, FieldParser>(){
        {
            this.put(Effects.Effect.class, (type, data) -> ContentParser.this.field(Fx.class, data));
            this.put(StatusEffect.class, (type, data) -> ContentParser.this.field(StatusEffects.class, data));
            this.put(Loadout.class, (type, data) -> ContentParser.this.field(Loadouts.class, data));
            this.put(Color.class, (type, data) -> Color.valueOf(data.asString()));
            this.put(BulletType.class, (type, data) -> {
                if (data.isString()) {
                    return ContentParser.this.field(Bullets.class, data);
                }
                Class bc = data.has("type") ? ContentParser.this.resolve(data.getString("type"), new String[]{"io.anuke.mindustry.entities.bullet"}) : BasicBulletType.class;
                data.remove("type");
                BulletType result = (BulletType)ContentParser.this.make(bc);
                ContentParser.this.readFields(result, data);
                return result;
            });
            this.put(Sound.class, (type, data) -> {
                if (ContentParser.this.fieldOpt(Sounds.class, data) != null) {
                    return ContentParser.this.fieldOpt(Sounds.class, data);
                }
                if (Vars.headless) {
                    return new MockSound();
                }
                String name = "sounds/" + data.asString();
                String path = Vars.tree.get(name + ".ogg").exists() && !Vars.ios ? name + ".ogg" : name + ".mp3";
                ModLoadingSound sound = new ModLoadingSound();
                Core.assets.load((String)path, Sound.class).loaded = result -> {
                    sound.sound = (Sound)result;
                };
                return sound;
            });
            this.put(Objective.class, (type, data) -> {
                Class oc = data.has("type") ? ContentParser.this.resolve(data.getString("type"), new String[]{"io.anuke.mindustry.game.Objectives"}) : Objectives.ZoneWave.class;
                data.remove("type");
                Objective obj = (Objective)ContentParser.this.make(oc);
                ContentParser.this.readFields(obj, data);
                return obj;
            });
            this.put(Weapon.class, (type, data) -> {
                Weapon weapon = new Weapon();
                ContentParser.this.readFields(weapon, data);
                weapon.name = ((ContentParser)ContentParser.this).currentMod.name + "-" + weapon.name;
                return weapon;
            });
        }
    };
    private Array<Runnable> reads = new Array();
    private Array<Runnable> postreads = new Array();
    private ObjectSet<Object> toBeParsed = new ObjectSet();
    private Mods.LoadedMod currentMod;
    private Content currentContent;
    private Json parser = new Json(){

        @Override
        public <T> T readValue(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            T t = this.internalRead(type, elementType, jsonData, keyType);
            if (t != null) {
                ContentParser.this.checkNullFields(t);
            }
            return t;
        }

        private <T> T internalRead(Class<T> type, Class elementType, JsonValue jsonData, Class keyType) {
            if (type != null) {
                if (ContentParser.this.classParsers.containsKey(type)) {
                    try {
                        return (T)((FieldParser)ContentParser.this.classParsers.get(type)).parse(type, jsonData);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (Content.class.isAssignableFrom(type)) {
                    String prefix;
                    ContentType ctype = (ContentType)((Object)ContentParser.this.contentTypes.getThrow(type, () -> new IllegalArgumentException("No content type for class: " + type.getSimpleName())));
                    Object one = Vars.content.getByName(ctype, (prefix = ContentParser.this.currentMod != null ? ((ContentParser)ContentParser.this).currentMod.name + "-" : "") + jsonData.asString());
                    if (one != null) {
                        return one;
                    }
                    Object two = Vars.content.getByName(ctype, jsonData.asString());
                    if (two != null) {
                        return two;
                    }
                    throw new IllegalArgumentException("\"" + jsonData.name + "\": No " + (Object)((Object)ctype) + " found with name '" + jsonData.asString() + "'.");
                }
            }
            return super.readValue(type, elementType, jsonData, keyType);
        }
    };
    private ObjectMap<ContentType, TypeParser<?>> parsers = ObjectMap.of(new Object[]{ContentType.block, (mod, name, value) -> {
        Block block;
        this.readBundle(ContentType.block, name, value);
        if (Vars.content.getByName(ContentType.block, name) != null) {
            block = (Block)Vars.content.getByName(ContentType.block, name);
            if (value.has("type")) {
                throw new IllegalArgumentException("When overwriting an existing block, you must not re-declare its type. The original type will be used. Block: " + name);
            }
        } else {
            Class type = this.resolve(this.getType(value), "io.anuke.mindustry.world", "io.anuke.mindustry.world.blocks", "io.anuke.mindustry.world.blocks.defense", "io.anuke.mindustry.world.blocks.defense.turrets", "io.anuke.mindustry.world.blocks.distribution", "io.anuke.mindustry.world.blocks.logic", "io.anuke.mindustry.world.blocks.power", "io.anuke.mindustry.world.blocks.production", "io.anuke.mindustry.world.blocks.sandbox", "io.anuke.mindustry.world.blocks.storage", "io.anuke.mindustry.world.blocks.units");
            block = (Block)this.make(type, mod + "-" + name);
        }
        this.currentContent = block;
        String[] research = new String[]{null};
        if (value.has("research")) {
            research[0] = value.get("research").asString();
            value.remove("research");
        }
        this.read(() -> {
            if (value.has("consumes")) {
                for (JsonValue child : value.get("consumes")) {
                    if (child.name.equals("item")) {
                        block.consumes.item((Item)this.find(ContentType.item, child.asString()));
                        continue;
                    }
                    if (child.name.equals("items")) {
                        block.consumes.add((Consume)this.parser.readValue(ConsumeItems.class, child));
                        continue;
                    }
                    if (child.name.equals("liquid")) {
                        block.consumes.add((Consume)this.parser.readValue(ConsumeLiquid.class, child));
                        continue;
                    }
                    if (child.name.equals("power")) {
                        if (child.isDouble()) {
                            block.consumes.power(child.asFloat());
                            continue;
                        }
                        block.consumes.add((Consume)this.parser.readValue(ConsumePower.class, child));
                        continue;
                    }
                    if (child.name.equals("powerBuffered")) {
                        block.consumes.powerBuffered(child.asFloat());
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown consumption type: '" + child.name + "' for block '" + block.name + "'.");
                }
                value.remove("consumes");
            }
            this.readFields(block, value, true);
            if (research[0] != null) {
                Block parent = (Block)this.find(ContentType.block, research[0]);
                TechTree.TechNode baseNode = TechTree.create(parent, block);
                this.postreads.add(() -> {
                    TechTree.TechNode parnode = TechTree.all.find(t -> t.block == parent);
                    if (!parnode.children.contains(baseNode)) {
                        parnode.children.add(baseNode);
                    }
                });
            }
            if (value.has("requirements") && block.buildVisibility == BuildVisibility.hidden) {
                block.buildVisibility = BuildVisibility.shown;
            }
        });
        return block;
    }, ContentType.unit, (mod, name, value) -> {
        this.readBundle(ContentType.unit, name, value);
        Class type = this.resolve(this.getType(value), "io.anuke.mindustry.entities.type.base");
        UnitType unit = new UnitType(mod + "-" + name, this.supply(type));
        this.currentContent = unit;
        this.read(() -> this.readFields(unit, value, true));
        return unit;
    }, ContentType.item, this.parser(ContentType.item, Item::new), ContentType.liquid, this.parser(ContentType.liquid, Liquid::new), ContentType.mech, this.parser(ContentType.mech, Mech::new), ContentType.zone, this.parser(ContentType.zone, Zone::new)});

    private String getString(JsonValue value, String key) {
        if (value.has(key)) {
            return value.getString(key);
        }
        throw new IllegalArgumentException((this.currentContent == null ? "" : this.currentContent.sourceFile + ": ") + "You are missing a \"" + key + "\". It must be added before the file can be parsed.");
    }

    private String getType(JsonValue value) {
        return this.getString(value, "type");
    }

    private <T extends Content> T find(ContentType type, String name) {
        Object c = Vars.content.getByName(type, name);
        if (c == null) {
            c = Vars.content.getByName(type, this.currentMod.name + "-" + name);
        }
        if (c == null) {
            throw new IllegalArgumentException("No " + (Object)((Object)type) + " found with name '" + name + "'");
        }
        return c;
    }

    private <T extends Content> TypeParser<T> parser(ContentType type, Function<String, T> constructor) {
        return (mod, name, value) -> {
            Object item;
            if (Vars.content.getByName(type, name) != null) {
                item = Vars.content.getByName(type, name);
                this.readBundle(type, name, value);
            } else {
                this.readBundle(type, name, value);
                item = (Content)constructor.get(mod + "-" + name);
            }
            this.currentContent = item;
            this.read(() -> this.readFields(item, value));
            return item;
        };
    }

    private void readBundle(ContentType type, String name, JsonValue value) {
        UnlockableContent cont = Vars.content.getByName(type, name) instanceof UnlockableContent ? (UnlockableContent)Vars.content.getByName(type, name) : null;
        String entryName = cont == null ? (Object)((Object)type) + "." + this.currentMod.name + "-" + name + "." : (Object)((Object)type) + "." + cont.name + ".";
        I18NBundle bundle = Core.bundle;
        while (bundle.getParent() != null) {
            bundle = bundle.getParent();
        }
        if (value.has("name")) {
            bundle.getProperties().put(entryName + "name", value.getString("name"));
            if (cont != null) {
                cont.localizedName = value.getString("name");
            }
            value.remove("name");
        }
        if (value.has("description")) {
            bundle.getProperties().put(entryName + "description", value.getString("description"));
            if (cont != null) {
                cont.description = value.getString("description");
            }
            value.remove("description");
        }
    }

    private void read(Runnable run) {
        Content cont = this.currentContent;
        Mods.LoadedMod mod = this.currentMod;
        this.reads.add(() -> {
            this.currentMod = mod;
            this.currentContent = cont;
            run.run();
        });
    }

    private void init() {
        for (ContentType type : ContentType.all) {
            Array arr = Vars.content.getBy(type);
            if (arr.isEmpty()) continue;
            Class<?> c = ((Content)arr.first()).getClass();
            while (c.getSuperclass() != Content.class && c.getSuperclass() != UnlockableContent.class && !Modifier.isAbstract(c.getSuperclass().getModifiers())) {
                c = c.getSuperclass();
            }
            this.contentTypes.put(c, type);
        }
    }

    public void finishParsing() {
        try {
            this.reads.each(Runnable::run);
            this.postreads.each(Runnable::run);
        }
        catch (Exception e) {
            Vars.mods.handleError(new Mods.ModLoadException("Error occurred parsing content: " + this.currentContent, this.currentContent, e), this.currentMod);
        }
        this.reads.clear();
        this.postreads.clear();
        this.toBeParsed.clear();
    }

    public Content parse(Mods.LoadedMod mod, String name, String json, FileHandle file, ContentType type) throws Exception {
        if (this.contentTypes.isEmpty()) {
            this.init();
        }
        JsonValue value = (JsonValue)this.parser.fromJson(null, json);
        if (!this.parsers.containsKey(type)) {
            throw new SerializationException("No parsers for content type '" + (Object)((Object)type) + "'");
        }
        this.currentMod = mod;
        boolean exists = Vars.content.getByName(type, name) != null;
        Object c = this.parsers.get(type).parse(mod.name, name, value);
        this.toBeParsed.add(c);
        if (!exists) {
            ((Content)c).sourceFile = file;
            ((Content)c).mod = mod;
        }
        return c;
    }

    private <T> T make(Class<T> type) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T make(Class<T> type, String name) {
        try {
            Constructor<T> cons = type.getDeclaredConstructor(String.class);
            cons.setAccessible(true);
            return cons.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Supplier<T> supply(Class<T> type) {
        try {
            Constructor cons = type.getDeclaredConstructor(new Class[0]);
            return () -> {
                try {
                    return cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object field(Class<?> type, JsonValue value) {
        return this.field(type, value.asString());
    }

    private Object field(Class<?> type, String name) {
        try {
            Object b = type.getField(name).get(null);
            if (b == null) {
                throw new IllegalArgumentException(type.getSimpleName() + ": not found: '" + name + "'");
            }
            return b;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object fieldOpt(Class<?> type, JsonValue value) {
        try {
            return type.getField(value.asString()).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void checkNullFields(Object object) {
        if (object instanceof Number || object instanceof String || this.toBeParsed.contains(object)) {
            return;
        }
        this.parser.getFields(object.getClass()).values().toArray().each(field -> {
            try {
                if (field.field.getType().isPrimitive()) {
                    return;
                }
                if (field.field.isAnnotationPresent(ArcAnnotate.NonNull.class) && field.field.get(object) == null) {
                    throw new RuntimeException("'" + field.field.getName() + "' in " + object.getClass().getSimpleName() + " is missing!");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void readFields(Object object, JsonValue jsonMap, boolean stripType) {
        if (stripType) {
            jsonMap.remove("type");
        }
        this.readFields(object, jsonMap);
    }

    private void readFields(Object object, JsonValue jsonMap) {
        this.toBeParsed.remove(object);
        Class<?> type = object.getClass();
        OrderedMap<String, Json.FieldMetadata> fields = this.parser.getFields(type);
        JsonValue child = jsonMap.child;
        while (child != null) {
            Json.FieldMetadata metadata = (Json.FieldMetadata)fields.get(child.name().replace(" ", "_"));
            if (metadata == null) {
                Log.err("{0}: Ignoring unknown field: " + child.name + " (" + type.getName() + ")", object);
            } else {
                Field field = metadata.field;
                try {
                    field.set(object, this.parser.readValue(field.getType(), metadata.elementType, child, metadata.keyType));
                }
                catch (ReflectionException ex) {
                    throw new SerializationException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (SerializationException ex) {
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    SerializationException ex = new SerializationException(runtimeEx);
                    ex.addTrace(child.trace());
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
            }
            child = child.next;
        }
    }

    private <T> Class<T> resolve(String base, String ... potentials) {
        if (!base.isEmpty() && Character.isLowerCase(base.charAt(0))) {
            base = Strings.capitalize(base);
        }
        for (String type : potentials) {
            try {
                return Class.forName(type + '.' + base);
            }
            catch (Exception ignored) {
                try {
                    return Class.forName(type + '$' + base);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new IllegalArgumentException("Types not found: " + base + "." + potentials[0]);
    }

    private static interface TypeParser<T extends Content> {
        public T parse(String var1, String var2, JsonValue var3) throws Exception;
    }

    private static interface FieldParser {
        public Object parse(Class<?> var1, JsonValue var2) throws Exception;
    }
}

