/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.generators;

import io.anuke.arc.collection.Array;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.maps.generators.Generator;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Loadout;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import io.anuke.mindustry.world.blocks.storage.StorageBlock;

public class MapGenerator
extends Generator {
    private Map map;
    private String mapName;
    private Array<Decoration> decorations = Array.with(new Decoration(Blocks.stone, Blocks.rock, 0.003f));
    public int enemySpawns = -1;
    public boolean distortFloor = false;

    public MapGenerator(String mapName) {
        this.decor(new Decoration(Blocks.snow, Blocks.snowrock, 0.01), new Decoration(Blocks.ignarock, Blocks.pebbles, 0.03f));
        this.mapName = mapName;
    }

    public MapGenerator(String mapName, int enemySpawns) {
        this.decor(new Decoration(Blocks.snow, Blocks.snowrock, 0.01), new Decoration(Blocks.ignarock, Blocks.pebbles, 0.03f));
        this.mapName = mapName;
        this.enemySpawns = enemySpawns;
    }

    public MapGenerator decor(Decoration ... decor) {
        this.decorations.addAll((Decoration[])decor);
        return this;
    }

    public void removePrefix(String name) {
        this.mapName = this.mapName.substring(name.length() + 1);
    }

    public Map getMap() {
        return this.map;
    }

    @Override
    public void init(Loadout loadout) {
        this.loadout = loadout;
        this.map = Vars.maps.loadInternalMap(this.mapName);
        this.width = this.map.width;
        this.height = this.map.height;
    }

    @Override
    public void generate(Tile[][] tiles) {
        Point2 core;
        int y;
        int x;
        for (int x2 = 0; x2 < this.width; ++x2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                tiles[x2][y2] = new Tile(x2, y2);
            }
        }
        SaveIO.load(this.map.file);
        Array<Point2> players = new Array<Point2>();
        Array<Point2> enemies = new Array<Point2>();
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (tiles[x][y].block() instanceof CoreBlock && tiles[x][y].getTeam() == Vars.defaultTeam) {
                    players.add(new Point2(x, y));
                    tiles[x][y].setBlock(Blocks.air);
                }
                if (tiles[x][y].overlay() == Blocks.spawn && this.enemySpawns != -1) {
                    enemies.add(new Point2(x, y));
                    tiles[x][y].setOverlay(Blocks.air);
                }
                if (!(tiles[x][y].block() instanceof BlockPart)) continue;
                tiles[x][y].setBlock(Blocks.air);
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                Tile tile = tiles[x][y];
                for (Decoration decor : this.decorations) {
                    if (x > 0 && y > 0 && (tiles[x - 1][y].block() == decor.wall || tiles[x][y - 1].block() == decor.wall)) continue;
                    if (tile.block() == Blocks.air && !(decor.wall instanceof Floor) && tile.floor() == decor.floor && Mathf.chance(decor.chance)) {
                        tile.setBlock(decor.wall);
                        continue;
                    }
                    if (tile.floor() == decor.floor && decor.wall.isOverlay() && Mathf.chance(decor.chance)) {
                        tile.setOverlay(decor.wall);
                        continue;
                    }
                    if (tile.floor() != decor.floor || !decor.wall.isFloor() || decor.wall.isOverlay() || !Mathf.chance(decor.chance)) continue;
                    tile.setFloor((Floor)decor.wall);
                }
                if (!(tile.block() instanceof StorageBlock) || tile.block() instanceof CoreBlock || Vars.world.getZone() == null) continue;
                for (Item item : Vars.world.getZone().resources) {
                    if (!Mathf.chance(0.3)) continue;
                    tile.entity.items.add(item, Math.min(Mathf.random(500), tile.block().itemCapacity));
                }
            }
        }
        if (this.enemySpawns != -1) {
            if (this.enemySpawns > enemies.size) {
                throw new IllegalArgumentException("Enemy spawn pool greater than map spawn number for map: " + this.mapName);
            }
            enemies.shuffle();
            for (int i = 0; i < this.enemySpawns; ++i) {
                Point2 point = (Point2)enemies.get(i);
                tiles[point.x][point.y].setOverlay(Blocks.spawn);
                int rad = 10;
                int frad = 12;
                for (int x3 = -rad; x3 <= rad; ++x3) {
                    for (int y3 = -rad; y3 <= rad; ++y3) {
                        Tile tile;
                        int wx = x3 + point.x;
                        int wy = y3 + point.y;
                        double dst = Mathf.dst(x3, y3);
                        if (!(dst < (double)frad) || !Structs.inBounds(wx, wy, tiles) || !(dst <= (double)rad) && !Mathf.chance(0.5) || (tile = tiles[wx][wy]).overlay() == Blocks.spawn) continue;
                        tile.clearOverlay();
                    }
                }
            }
        }
        if ((core = (Point2)players.random()) == null) {
            throw new IllegalArgumentException("All zone maps must have a core.");
        }
        this.loadout.setup(core.x, core.y);
        Vars.world.prepareTiles(tiles);
        Vars.world.setMap(this.map);
    }

    public static class Decoration {
        public final Block floor;
        public final Block wall;
        public final double chance;

        public Decoration(Block floor, Block wall, double chance) {
            this.floor = floor;
            this.wall = wall;
            this.chance = chance;
        }
    }
}

