/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Block;

public class TerrainFilter
extends GenerateFilter {
    float scl = 40.0f;
    float threshold = 0.9f;
    float octaves = 3.0f;
    float falloff = 0.5f;
    float magnitude = 1.0f;
    float circleScl = 2.1f;
    Block floor = Blocks.stone;
    Block block = Blocks.rocks;

    public TerrainFilter() {
        this.options(new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("mag", () -> this.magnitude, f -> {
            this.magnitude = f;
        }, 0.0f, 2.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("circle-scale", () -> this.circleScl, f -> {
            this.circleScl = f;
        }, 0.0f, 3.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOnly), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOnly));
    }

    @Override
    public void apply() {
        float noise = this.noise(this.in.x, this.in.y, this.scl, this.magnitude, this.octaves, this.falloff) + Mathf.dst((float)this.in.x / (float)this.in.width, (float)this.in.y / (float)this.in.height, 0.5f, 0.5f) * this.circleScl;
        this.in.floor = this.floor;
        this.in.ore = Blocks.air;
        this.in.block = noise >= this.threshold ? this.block : Blocks.air;
    }
}

