/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Block;

public class NoiseFilter
extends GenerateFilter {
    float scl = 40.0f;
    float threshold = 0.5f;
    float octaves = 3.0f;
    float falloff = 0.5f;
    Block floor = Blocks.stone;
    Block block = Blocks.rocks;

    public NoiseFilter() {
        this.options(new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOnly), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOnly));
    }

    @Override
    public void apply() {
        float noise = this.noise(this.in.x, this.in.y, this.scl, 1.0f, this.octaves, this.falloff);
        if (noise > this.threshold) {
            this.in.floor = this.floor;
            if (FilterOption.wallsOnly.test(this.in.block)) {
                this.in.block = this.block;
            }
        }
    }
}

