/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.Core;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.noise.RidgedPerlin;
import io.anuke.arc.util.noise.Simplex;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;

public abstract class GenerateFilter {
    protected transient float o = (float)(Math.random() * 1.0E7);
    protected transient long seed;
    protected transient GenerateInput in;
    public transient boolean buffered = false;
    public transient FilterOption[] options;

    public final void apply(GenerateInput in) {
        this.in = in;
        this.apply();
        if (((Floor)in.floor).isLiquid) {
            in.ore = Blocks.air;
        }
    }

    protected void options(FilterOption ... options) {
        this.options = options;
    }

    protected abstract void apply();

    public void draw(Image image) {
    }

    public String name() {
        return Core.bundle.get("filter." + this.getClass().getSimpleName().toLowerCase().replace("filter", ""), this.getClass().getSimpleName().replace("Filter", ""));
    }

    public void randomize() {
        this.seed = Mathf.random(99999999);
    }

    protected float noise(float x, float y, float scl, float mag) {
        return (float)this.in.noise.octaveNoise2D(1.0, 0.0, 1.0f / scl, x + this.o, y + this.o) * mag;
    }

    protected float noise(float x, float y, float scl, float mag, float octaves, float persistence) {
        return (float)this.in.noise.octaveNoise2D(octaves, persistence, 1.0f / scl, x + this.o, y + this.o) * mag;
    }

    protected float rnoise(float x, float y, float scl, float mag) {
        return this.in.pnoise.getValue((int)(x + this.o), (int)(y + this.o), 1.0f / scl) * mag;
    }

    protected float chance() {
        return Mathf.randomSeed(Pack.longInt(this.in.x, this.in.y + (int)this.seed));
    }

    public static class GenerateInput {
        public int x;
        public int y;
        public int width;
        public int height;
        public Block floor;
        public Block block;
        public Block ore;
        Simplex noise = new Simplex();
        RidgedPerlin pnoise = new RidgedPerlin(0, 1);
        TileProvider buffer;

        public void apply(int x, int y, Block floor, Block block, Block ore) {
            this.floor = floor;
            this.block = block;
            this.ore = ore;
            this.x = x;
            this.y = y;
        }

        public void begin(GenerateFilter filter, int width, int height, TileProvider buffer) {
            this.buffer = buffer;
            this.width = width;
            this.height = height;
            this.noise.setSeed(filter.seed);
            this.pnoise.setSeed((int)(filter.seed + 1L));
        }

        Tile tile(float x, float y) {
            return this.buffer.get(Mathf.clamp((int)x, 0, this.width - 1), Mathf.clamp((int)y, 0, this.height - 1));
        }

        public static interface TileProvider {
            public Tile get(int var1, int var2);
        }
    }
}

