/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;

public class DistortFilter
extends GenerateFilter {
    float scl = 40.0f;
    float mag = 5.0f;

    public DistortFilter() {
        this.buffered = true;
        this.options(new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 200.0f), new FilterOption.SliderOption("mag", () -> this.mag, f -> {
            this.mag = f;
        }, 0.5f, 100.0f));
    }

    @Override
    public void apply() {
        Tile tile = this.in.tile((float)this.in.x + this.noise(this.in.x, this.in.y, this.scl, this.mag) - this.mag / 2.0f, (float)this.in.y + this.noise(this.in.x, (float)this.in.y + this.o, this.scl, this.mag) - this.mag / 2.0f);
        this.in.floor = tile.floor();
        if (!tile.block().synthetic() && !this.in.block.synthetic()) {
            this.in.block = tile.block();
        }
        if (!((Floor)this.in.floor).isLiquid) {
            this.in.ore = tile.overlay();
        }
    }
}

