/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class BlendFilter
extends GenerateFilter {
    float radius = 2.0f;
    Block block = Blocks.stone;
    Block floor = Blocks.ice;
    Block ignore = Blocks.air;

    public BlendFilter() {
        this.buffered = true;
        this.options(new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 10.0f), new FilterOption.BlockOption("block", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOnly), new FilterOption.BlockOption("ignore", () -> this.ignore, b -> {
            this.ignore = b;
        }, FilterOption.floorsOptional));
    }

    @Override
    public void apply() {
        if (this.in.floor == this.block || this.block == Blocks.air || this.in.floor == this.ignore) {
            return;
        }
        int rad = (int)this.radius;
        boolean found = false;
        block0: for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                if (Mathf.dst2(x, y) > (float)(rad * rad) || (tile = this.in.tile(this.in.x + x, this.in.y + y)).floor() != this.block && tile.block() != this.block && tile.overlay() != this.block) continue;
                found = true;
                break block0;
            }
        }
        if (found) {
            this.in.floor = this.floor;
        }
    }
}

